/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratDocument;
import opennlp.tools.formats.brat.BratDocumentStream;
import opennlp.tools.formats.brat.BratNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.sentdetect.NewlineSentenceDetector;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.ObjectStream;

public class BratNameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample, Parameters> {
    protected BratNameSampleStreamFactory() {
        super(Parameters.class);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "brat", new BratNameSampleStreamFactory());
    }

    private boolean notNull(Object ... objects) {
        for (Object obj : objects) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        String[] nameTypesArr;
        SentenceDetector sentDetector;
        BratDocumentStream samples;
        AnnotationConfiguration annConfig;
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        if (this.notNull(params.getRuleBasedTokenizer(), params.getTokenizerModel())) {
            throw new TerminateToolException(-1, "Either use rule based or statistical tokenizer!");
        }
        try {
            annConfig = AnnotationConfiguration.parse(params.getAnnotationConfig());
        }
        catch (IOException e) {
            throw new TerminateToolException(1, "Failed to parse annotation.conf file!");
        }
        try {
            samples = new BratDocumentStream(annConfig, params.getBratDataDir(), params.getRecursive(), null);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, e.getMessage());
        }
        if (params.getSentenceDetectorModel() != null) {
            try {
                sentDetector = new SentenceDetectorME(new SentenceModel(params.getSentenceDetectorModel()));
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load sentence detector model!", e);
            }
        } else {
            sentDetector = new NewlineSentenceDetector();
        }
        AbstractTokenizer tokenizer = WhitespaceTokenizer.INSTANCE;
        if (params.getTokenizerModel() != null) {
            try {
                tokenizer = new TokenizerME(new TokenizerModel(params.getTokenizerModel()));
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load tokenizer model!", e);
            }
        } else if (params.getRuleBasedTokenizer() != null) {
            String tokenizerName = params.getRuleBasedTokenizer();
            if ("simple".equals(tokenizerName)) {
                tokenizer = SimpleTokenizer.INSTANCE;
            } else if ("whitespace".equals(tokenizerName)) {
                tokenizer = WhitespaceTokenizer.INSTANCE;
            } else {
                throw new TerminateToolException(-1, "Unknown tokenizer: " + tokenizerName);
            }
        }
        Set nameTypes = null;
        if (params.getNameTypes() != null && (nameTypesArr = params.getNameTypes().split(",")).length > 0) {
            nameTypes = Arrays.stream(nameTypesArr).map(String::trim).collect(Collectors.toSet());
        }
        return new BratNameSampleStream(sentDetector, tokenizer, (ObjectStream<BratDocument>)samples, nameTypes);
    }

    public static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="bratDataDir", description="location of brat data dir")
        public File getBratDataDir();

        @ArgumentParser.ParameterDescription(valueName="annConfFile")
        public File getAnnotationConfig();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        @ArgumentParser.OptionalParameter
        public File getSentenceDetectorModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        @ArgumentParser.OptionalParameter
        public File getTokenizerModel();

        @ArgumentParser.ParameterDescription(valueName="name")
        @ArgumentParser.OptionalParameter
        public String getRuleBasedTokenizer();

        @ArgumentParser.ParameterDescription(valueName="value")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getRecursive();

        @ArgumentParser.ParameterDescription(valueName="names")
        @ArgumentParser.OptionalParameter
        public String getNameTypes();
    }
}

