/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluPOSSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

@Internal
public class ConlluPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample, Parameters> {
    public static final String CONLLU_FORMAT = "conllu";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLU_FORMAT, new ConlluPOSSampleStreamFactory(Parameters.class));
    }

    protected ConlluPOSSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        ConlluTagset tagset = switch (params.getTagset()) {
            case "u" -> ConlluTagset.U;
            case "x" -> ConlluTagset.X;
            default -> throw new TerminateToolException(-1, "Unknown tagset parameter: " + params.getTagset());
        };
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
        try {
            return new ConlluPOSSampleStream(new ConlluStream(inFactory), tagset);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="tagset", description="u|x u for unified tags and x for language-specific part-of-speech tags")
        @ArgumentParser.OptionalParameter(defaultValue="u")
        public String getTagset();
    }
}

