/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.chunker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class ChunkerTrainer
extends CasConsumer_ImplBase {
    private List<ChunkSample> mChunkSamples = new ArrayList<ChunkSample>();
    private UimaContext mContext;
    private String mModelName;
    private Type mSentenceType;
    private Type mTokenType;
    private Feature mPOSFeature;
    private Type mChunkType;
    private Feature mChunkTagFeature;
    private Logger mLogger;
    private String language;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Chunker Trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
        String chunkTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkType");
        this.mChunkType = CasConsumerUtil.getType(typeSystem, chunkTypeName);
        String chunkTagFeature = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkTagFeature");
        this.mChunkTagFeature = this.mChunkType.getFeatureByBaseName(chunkTagFeature);
        CasConsumerUtil.checkFeatureType(this.mChunkTagFeature, "uima.cas.String");
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String posFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(posFeatureName);
        CasConsumerUtil.checkFeatureType(this.mPOSFeature, "uima.cas.String");
    }

    public void processCas(CAS cas) {
        AnnotationIndex sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            this.processSentence(cas, sentenceAnnotation);
        }
    }

    private void processSentence(CAS tcas, AnnotationFS sentence) {
        AnnotationIndex chunkIndex = tcas.getAnnotationIndex(this.mChunkType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentence);
        FSIterator chunkIterator = tcas.createFilteredIterator(chunkIndex.iterator(), (FSMatchConstraint)containingConstraint);
        while (chunkIterator.hasNext()) {
            AnnotationFS chunkAnnotation = (AnnotationFS)chunkIterator.next();
            this.processChunk(tcas, chunkAnnotation);
        }
    }

    private void processChunk(CAS tcas, AnnotationFS chunk) {
        String chunkTag = chunk.getFeatureValueAsString(this.mChunkTagFeature);
        AnnotationIndex tokenIndex = tcas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(chunk);
        FSIterator tokenIterator = tcas.createFilteredIterator(tokenIndex.iterator(), (FSMatchConstraint)containingConstraint);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> chunkTags = new ArrayList<String>();
        while (tokenIterator.hasNext()) {
            AnnotationFS tokenAnnotation = (AnnotationFS)tokenIterator.next();
            tokens.add(tokenAnnotation.getCoveredText().trim());
            tags.add(tokenAnnotation.getFeatureValueAsString(this.mPOSFeature));
            chunkTags.add(chunkTag);
        }
        this.mChunkSamples.add(new ChunkSample(tokens, tags, chunkTags));
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        ChunkerModel chunkerModel = ChunkerME.train((String)this.language, (ObjectStream)ObjectStreamUtils.createObjectStream(this.mChunkSamples), (TrainingParameters)ModelUtil.createDefaultTrainingParameters(), (ChunkerFactory)ChunkerFactory.create(null));
        this.mChunkSamples = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize((BaseModel)chunkerModel, modelFile);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mChunkSamples = null;
    }
}

