/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class NumberUtil {
    public static boolean isLanguageSupported(String languageCode) {
        Locale locale = new Locale(languageCode);
        Locale[] possibleLocales = NumberFormat.getAvailableLocales();
        boolean isLocaleSupported = false;
        for (Locale possibleLocale : possibleLocales) {
            if (!possibleLocale.equals(locale)) continue;
            isLocaleSupported = true;
            break;
        }
        return isLocaleSupported;
    }

    private static String removeChar(String string, char remove) {
        StringBuilder result = new StringBuilder();
        int lastPosition = 0;
        int position = 0;
        while ((position = string.indexOf(remove, lastPosition)) != -1) {
            result.append(string.substring(lastPosition, position));
            lastPosition = position + 1;
        }
        result.append(string.substring(lastPosition, string.length()));
        return result.toString();
    }

    public static Number parse(String number, String languageCode) throws ParseException {
        if (!NumberUtil.isLanguageSupported(languageCode)) {
            throw new IllegalArgumentException("Language " + languageCode + " is not supported!");
        }
        Locale locale = new Locale(languageCode);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        number = number.trim();
        number = NumberUtil.removeChar(number, ' ');
        return numberFormat.parse(number);
    }
}

