/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Set;
import opennlp.tools.util.StringList;
import opennlp.uima.normalizer.NumberUtil;
import opennlp.uima.normalizer.StringDictionary;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Normalizer
extends CasAnnotator_ImplBase {
    private static final Set<String> SUPPORTED_TYPES = Set.of("uima.cas.String", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double");
    private UimaContext context;
    private Logger mLogger;
    private Type mNameType;
    private Feature mStructureFeature;
    private StringDictionary mLookupDictionary;

    private Normalizer() {
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Normalizer annotator.");
        }
        try {
            String modelName = AnnotatorUtil.getOptionalStringParameter(context, "opennlp.uima.Dictionary");
            if (modelName != null) {
                InputStream inModel = AnnotatorUtil.getResourceAsStream(context, modelName);
                this.mLookupDictionary = new StringDictionary(inModel);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
        this.mStructureFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mNameType, "opennlp.uima.normalizer.StructureFeature");
        if (!SUPPORTED_TYPES.contains(this.mStructureFeature.getRange().getName())) {
            throw new AnalysisEngineProcessException("opennlp.uima.util.ExceptionMessages", "range_type_unsupported", new Object[]{this.mStructureFeature.getRange().getName()});
        }
    }

    public void process(CAS tcas) {
        AnnotationIndex sentenceIndex = tcas.getAnnotationIndex(this.mNameType);
        for (AnnotationFS nameAnnotation : sentenceIndex) {
            Number number;
            String name;
            StringList tokens;
            String normalizedText;
            String language = tcas.getDocumentLanguage();
            if (!NumberUtil.isLanguageSupported(language)) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Unsupported language: " + language);
                continue;
            }
            String text = nameAnnotation.getCoveredText();
            if (this.mLookupDictionary != null && (normalizedText = this.mLookupDictionary.get(tokens = new StringList(text))) != null) {
                text = normalizedText;
            }
            if ("uima.cas.String".equals(name = this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setStringValue(this.mStructureFeature, text);
                continue;
            }
            try {
                number = NumberUtil.parse(text, language);
            }
            catch (ParseException e) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Invalid number format: " + text);
                continue;
            }
            if ("uima.cas.Byte".equals(name)) {
                nameAnnotation.setByteValue(this.mStructureFeature, number.byteValue());
                continue;
            }
            if ("uima.cas.Short".equals(name)) {
                nameAnnotation.setShortValue(this.mStructureFeature, number.shortValue());
                continue;
            }
            if ("uima.cas.Integer".equals(name)) {
                nameAnnotation.setIntValue(this.mStructureFeature, number.intValue());
                continue;
            }
            if ("uima.cas.Long".equals(name)) {
                nameAnnotation.setLongValue(this.mStructureFeature, number.longValue());
                continue;
            }
            if ("uima.cas.Float".equals(name)) {
                nameAnnotation.setFloatValue(this.mStructureFeature, number.floatValue());
                continue;
            }
            if (!"uima.cas.Double".equals(name)) continue;
            nameAnnotation.setDoubleValue(this.mStructureFeature, number.doubleValue());
        }
    }
}

