/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.dictionary.Dictionary;
import opennlp.uima.util.OpenNlpAnnotatorProcessException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class AnnotatorUtil {
    private AnnotatorUtil() {
    }

    public static Type getType(TypeSystem typeSystem, String name) throws AnalysisEngineProcessException {
        Type type = typeSystem.getType(name);
        if (type == null) {
            throw new OpenNlpAnnotatorProcessException("type_not_found", new Object[]{name});
        }
        return type;
    }

    private static void checkFeatureType(Feature feature, String expectedType) throws AnalysisEngineProcessException {
        if (!feature.getRange().getName().equals(expectedType)) {
            throw new OpenNlpAnnotatorProcessException("wrong_feature_type", new Object[]{feature.getName(), expectedType});
        }
    }

    public static Feature getRequiredFeature(Type type, String featureName) throws AnalysisEngineProcessException {
        Feature feature = type.getFeatureByBaseName(featureName);
        if (feature == null) {
            throw new OpenNlpAnnotatorProcessException("feature_not_found", new Object[]{type.getName(), featureName});
        }
        return feature;
    }

    public static Feature getRequiredFeature(Type type, String featureName, String rangeType) throws AnalysisEngineProcessException {
        Feature feature = AnnotatorUtil.getRequiredFeature(type, featureName);
        AnnotatorUtil.checkFeatureType(feature, rangeType);
        return feature;
    }

    public static Feature getRequiredFeatureParameter(UimaContext context, Type type, String featureNameParameter) throws AnalysisEngineProcessException {
        String featureName;
        try {
            featureName = AnnotatorUtil.getRequiredStringParameter(context, featureNameParameter);
        }
        catch (ResourceInitializationException e) {
            throw new OpenNlpAnnotatorProcessException(e);
        }
        return AnnotatorUtil.getRequiredFeature(type, featureName);
    }

    public static Feature getRequiredFeatureParameter(UimaContext context, Type type, String featureNameParameter, String rangeTypeName) throws AnalysisEngineProcessException {
        String featureName;
        try {
            featureName = AnnotatorUtil.getRequiredStringParameter(context, featureNameParameter);
        }
        catch (ResourceInitializationException e) {
            throw new OpenNlpAnnotatorProcessException(e);
        }
        return AnnotatorUtil.getRequiredFeature(type, featureName, rangeTypeName);
    }

    public static Type getRequiredTypeParameter(UimaContext context, TypeSystem typeSystem, String parameter) throws AnalysisEngineProcessException {
        String typeName;
        try {
            typeName = AnnotatorUtil.getRequiredStringParameter(context, parameter);
        }
        catch (ResourceInitializationException e) {
            throw new OpenNlpAnnotatorProcessException(e);
        }
        return AnnotatorUtil.getType(typeSystem, typeName);
    }

    public static String getRequiredStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        String value = AnnotatorUtil.getOptionalStringParameter(context, parameter);
        AnnotatorUtil.checkForNull(value, parameter);
        return value;
    }

    public static Integer getRequiredIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Integer value = AnnotatorUtil.getOptionalIntegerParameter(context, parameter);
        AnnotatorUtil.checkForNull(value, parameter);
        return value;
    }

    public static Float getRequiredFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Float value = AnnotatorUtil.getOptionalFloatParameter(context, parameter);
        AnnotatorUtil.checkForNull(value, parameter);
        return value;
    }

    public static Boolean getRequiredBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Boolean value = AnnotatorUtil.getOptionalBooleanParameter(context, parameter);
        AnnotatorUtil.checkForNull(value, parameter);
        return value;
    }

    private static void checkForNull(Object value, String parameterName) throws ResourceInitializationException {
        if (value == null) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "parameter_not_found", new Object[]{parameterName});
        }
    }

    public static Feature getOptionalFeatureParameter(UimaContext context, Type nameType, String featureNameParameter, String rangeTypeName) throws AnalysisEngineProcessException {
        String featureName;
        try {
            featureName = AnnotatorUtil.getOptionalStringParameter(context, featureNameParameter);
        }
        catch (ResourceInitializationException e) {
            throw new OpenNlpAnnotatorProcessException(e);
        }
        if (featureName != null) {
            return AnnotatorUtil.getOptionalFeature(nameType, featureName, rangeTypeName);
        }
        return null;
    }

    public static Feature getOptionalFeature(Type type, String featureName, String rangeType) throws AnalysisEngineProcessException {
        Feature feature = type.getFeatureByBaseName(featureName);
        AnnotatorUtil.checkFeatureType(feature, rangeType);
        return feature;
    }

    public static Type getOptionalTypeParameter(UimaContext context, TypeSystem typeSystem, String parameter) throws AnalysisEngineProcessException {
        String typeName;
        try {
            typeName = AnnotatorUtil.getOptionalStringParameter(context, parameter);
        }
        catch (ResourceInitializationException e) {
            throw new OpenNlpAnnotatorProcessException(e);
        }
        if (typeName != null) {
            return AnnotatorUtil.getType(typeSystem, typeName);
        }
        return null;
    }

    public static String getOptionalStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = AnnotatorUtil.getOptionalParameter(context, parameter);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{parameter, "String"});
    }

    public static String[] getOptionalStringArrayParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = AnnotatorUtil.getOptionalParameter(context, parameter);
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{parameter, "String array"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = AnnotatorUtil.getOptionalParameter(context, parameter);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{parameter, "Integer"});
    }

    public static Float getOptionalFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = AnnotatorUtil.getOptionalParameter(context, parameter);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{parameter, "Float"});
    }

    public static Boolean getOptionalBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = AnnotatorUtil.getOptionalParameter(context, parameter);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{parameter, "Boolean"});
    }

    private static Object getOptionalParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = context.getConfigParameterValue(parameter);
        Logger logger = context.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, parameter + " = " + (value != null ? value.toString() : "not set"));
        }
        return value;
    }

    public static InputStream getResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        InputStream inResource = AnnotatorUtil.getOptionalResourceAsStream(context, name);
        if (inResource == null) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{name + " could not be found!"});
        }
        return inResource;
    }

    public static InputStream getOptionalResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        InputStream inResource;
        try {
            inResource = context.getResourceAsStream(name);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        return inResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dictionary createOptionalDictionary(UimaContext context, String dictionaryParameter) throws ResourceInitializationException {
        String dictionaryName = AnnotatorUtil.getOptionalStringParameter(context, dictionaryParameter);
        Dictionary dictionary = null;
        if (dictionaryName == null) return null;
        Logger logger = context.getLogger();
        try (InputStream dictIn = AnnotatorUtil.getOptionalResourceAsStream(context, dictionaryName);){
            if (dictIn == null) {
                String message = "The dictionary file " + dictionaryName + " does not exist!";
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, message);
                }
                Dictionary dictionary2 = null;
                return dictionary2;
            }
            dictionary = new Dictionary(dictIn);
            return dictionary;
        }
        catch (IOException e) {
            String message = "IOException during dictionary reading, running without dictionary: " + e.getMessage();
            if (!logger.isLoggable(Level.WARNING)) return dictionary;
            logger.log(Level.WARNING, message);
        }
        return dictionary;
    }
}

