/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.cditest.owb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.ResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.webbeans.cditest.CdiTestContainer;
import org.apache.webbeans.cditest.owb.MockHttpSession;
import org.apache.webbeans.cditest.owb.MockServletContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;

public class CdiTestOpenWebBeansContainer
implements CdiTestContainer {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(CdiTestOpenWebBeansContainer.class);
    private ContainerLifecycle lifecycle = null;
    private MockServletContext servletContext = null;
    private MockHttpSession session = null;

    public void bootContainer() throws Exception {
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        this.lifecycle = (ContainerLifecycle)WebBeansContext.getInstance().getService(ContainerLifecycle.class);
        this.lifecycle.startApplication((Object)new ServletContextEvent((ServletContext)this.servletContext));
    }

    public void shutdownContainer() throws Exception {
        if (this.lifecycle != null) {
            this.lifecycle.stopApplication((Object)new ServletContextEvent((ServletContext)this.servletContext));
        }
    }

    public void startContexts() throws Exception {
        logger.log(Level.FINE, "starting all OWB Contexts");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.startContext(Singleton.class, (Object)this.servletContext);
        contextsService.startContext(ApplicationScoped.class, (Object)this.servletContext);
        contextsService.startContext(SessionScoped.class, (Object)this.session);
        contextsService.startContext(ConversationScoped.class, null);
        contextsService.startContext(RequestScoped.class, null);
    }

    public void startApplicationScope() throws Exception {
        logger.log(Level.FINE, "starting the OWB ApplicationContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.startContext(ApplicationScoped.class, (Object)this.servletContext);
    }

    public void startConversationScope() throws Exception {
        logger.log(Level.FINE, "starting the OWB ConversationContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.startContext(ConversationScoped.class, null);
    }

    public void startCustomScope(Class<? extends Annotation> scopeClass) throws Exception {
    }

    public void startRequestScope() throws Exception {
        logger.log(Level.FINE, "starting the OWB RequestContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.startContext(RequestScoped.class, null);
    }

    public void startSessionScope() throws Exception {
        logger.log(Level.FINE, "starting the OWB SessionContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.startContext(SessionScoped.class, (Object)this.session);
    }

    public void stopContexts() throws Exception {
        logger.log(Level.FINE, "stopping all OWB Contexts");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        this.stopSessionScope();
        this.stopConversationScope();
        this.stopRequestScope();
        this.stopApplicationScope();
        contextsService.endContext(Singleton.class, null);
    }

    public void stopApplicationScope() throws Exception {
        logger.log(Level.FINE, "stopping the OWB ApplicationContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.endContext(ApplicationScoped.class, (Object)this.servletContext);
    }

    public void stopConversationScope() throws Exception {
        logger.log(Level.FINE, "stopping the OWB ConversationContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.endContext(ConversationScoped.class, null);
    }

    public void stopCustomScope(Class<? extends Annotation> scopeClass) throws Exception {
    }

    public void stopRequestScope() throws Exception {
        logger.log(Level.FINE, "stopping the OWB RequestContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.endContext(RequestScoped.class, null);
    }

    public void stopSessionScope() throws Exception {
        logger.log(Level.FINE, "stopping the OWB SessionContext");
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        contextsService.endContext(SessionScoped.class, (Object)this.session);
    }

    public BeanManager getBeanManager() {
        return this.lifecycle.getBeanManager();
    }

    public <T> T getInstance(Class<T> type, Annotation ... qualifiers) throws ResolutionException {
        Set beans = this.getBeanManager().getBeans(type, qualifiers);
        Bean bean = this.getBeanManager().resolve(beans);
        Object instance = this.getBeanManager().getReference(bean, type, this.getBeanManager().createCreationalContext((Contextual)bean));
        return (T)instance;
    }

    public Object getInstance(String name) throws ResolutionException {
        Set beans = this.getBeanManager().getBeans(name);
        Bean bean = this.getBeanManager().resolve(beans);
        Object instance = this.getBeanManager().getReference(bean, (Type)bean.getBeanClass(), this.getBeanManager().createCreationalContext((Contextual)bean));
        return instance;
    }
}

