/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.hdds.utils.SignalLogger;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;

public final class StringUtils {
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;

    private StringUtils() {
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    public static String toStartupShutdownString(String prefix, String ... msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n").append(prefix).append(s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(VersionInfo versionInfo, Class<?> clazz, String[] args, Logger log) {
        String hostname = NetUtils.getHostname();
        String className = clazz.getSimpleName();
        if (log.isInfoEnabled()) {
            log.info(StringUtils.createStartupShutdownMessage(versionInfo, className, hostname, args));
        }
        if (SystemUtils.IS_OS_UNIX) {
            try {
                SignalLogger.INSTANCE.register(log);
            }
            catch (Throwable t) {
                log.warn("failed to register any UNIX signal loggers: ", t);
            }
        }
        ShutdownHookManager.get().addShutdownHook(() -> log.info(StringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", "Shutting down " + className + " at " + hostname)), 0);
    }

    public static String createStartupShutdownMessage(VersionInfo versionInfo, String className, String hostname, String[] args) {
        return StringUtils.toStartupShutdownString("STARTUP_MSG: ", "Starting " + className, "  host = " + hostname, "  args = " + (args != null ? Arrays.asList(args) : new ArrayList()), "  version = " + versionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + versionInfo.getUrl() + "/" + versionInfo.getRevision() + " ; compiled by '" + versionInfo.getUser() + "' on " + versionInfo.getDate(), "  java = " + System.getProperty("java.version"));
    }

    public static String appendIfNotPresent(String str, char c) {
        Preconditions.checkNotNull((Object)str, (Object)"Input string is null");
        return str.isEmpty() || str.charAt(str.length() - 1) != c ? str + c : str;
    }
}

