/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class RatisReplicationConfig
implements ReplicationConfig {
    private final HddsProtos.ReplicationFactor replicationFactor;
    private static final HddsProtos.ReplicationType REPLICATION_TYPE = HddsProtos.ReplicationType.RATIS;

    public RatisReplicationConfig(HddsProtos.ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public RatisReplicationConfig(String factorString) {
        HddsProtos.ReplicationFactor factor = null;
        try {
            factor = HddsProtos.ReplicationFactor.valueOf((int)Integer.parseInt(factorString));
        }
        catch (NumberFormatException ex) {
            try {
                factor = HddsProtos.ReplicationFactor.valueOf((String)factorString);
            }
            catch (IllegalArgumentException x) {
                throw new IllegalArgumentException("Invalid RatisReplicationFactor '" + factorString + "'. Please use ONE or THREE!");
            }
        }
        this.replicationFactor = factor;
    }

    public static boolean hasFactor(ReplicationConfig replicationConfig, HddsProtos.ReplicationFactor factor) {
        if (replicationConfig instanceof RatisReplicationConfig) {
            return ((RatisReplicationConfig)replicationConfig).getReplicationFactor().equals((Object)factor);
        }
        return false;
    }

    @Override
    @JsonProperty(value="replicationType")
    public HddsProtos.ReplicationType getReplicationType() {
        return REPLICATION_TYPE;
    }

    @Override
    public int getRequiredNodes() {
        return this.replicationFactor.getNumber();
    }

    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatisReplicationConfig that = (RatisReplicationConfig)o;
        return this.replicationFactor == that.replicationFactor;
    }

    public String toString() {
        return REPLICATION_TYPE.name() + "/" + this.replicationFactor;
    }

    public int hashCode() {
        return Objects.hash(this.replicationFactor);
    }
}

