/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.conf;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis")
public class RatisClientConfig {
    @Config(key="client.request.write.timeout", defaultValue="5m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Timeout for ratis client write request.")
    private long writeRequestTimeoutInMs = Duration.ofMinutes(5L).toMillis();
    @Config(key="client.request.watch.timeout", defaultValue="3m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Timeout for ratis client watch request.")
    private long watchRequestTimeoutInMs = Duration.ofMinutes(3L).toMillis();
    @Config(key="client.multilinear.random.retry.policy", defaultValue="5s, 5, 10s, 5, 15s, 5, 20s, 5, 25s, 5, 60s, 10", type=ConfigType.STRING, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Specifies multilinear random retry policy to be used by ratis client. e.g. given pairs of number of retries and sleep time (n0, t0), (n1, t1), ..., for the first n0 retries sleep duration is t0 on average, the following n1 retries sleep duration is t1 on average, and so on.")
    private String multilinearPolicy;
    @Config(key="client.exponential.backoff.base.sleep", defaultValue="4s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Specifies base sleep for exponential backoff retry policy. With the default base sleep of 4s, the sleep duration for ith retry is min(4 * pow(2, i), max_sleep) * r, where r is random number in the range [0.5, 1.5).")
    private long exponentialPolicyBaseSleepInMs = Duration.ofSeconds(4L).toMillis();
    @Config(key="client.exponential.backoff.max.sleep", defaultValue="40s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The sleep duration obtained from exponential backoff policy is limited by the configured max sleep. Refer dfs.ratis.client.exponential.backoff.base.sleep for further details.")
    private long exponentialPolicyMaxSleepInMs = Duration.ofSeconds(40L).toMillis();
    @Config(key="client.retrylimited.retry.interval", defaultValue="1s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Interval between successive retries for a ratis client request.")
    private long retrylimitedRetryInterval;
    @Config(key="client.retrylimited.max.retries", defaultValue="180", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Number of retries for ratis client request.")
    private int retrylimitedMaxRetries;
    @Config(key="client.retry.policy", defaultValue="org.apache.hadoop.hdds.ratis.retrypolicy.RequestTypeDependentRetryPolicyCreator", type=ConfigType.STRING, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The class name of the policy for retry.")
    private String retryPolicy;

    public Duration getWriteRequestTimeout() {
        return Duration.ofMillis(this.writeRequestTimeoutInMs);
    }

    public void setWriteRequestTimeout(Duration duration) {
        this.writeRequestTimeoutInMs = duration.toMillis();
    }

    public Duration getWatchRequestTimeout() {
        return Duration.ofMillis(this.watchRequestTimeoutInMs);
    }

    public void setWatchRequestTimeout(Duration duration) {
        this.watchRequestTimeoutInMs = duration.toMillis();
    }

    public String getMultilinearPolicy() {
        return this.multilinearPolicy;
    }

    public void setMultilinearPolicy(String multilinearPolicy) {
        this.multilinearPolicy = multilinearPolicy;
    }

    public Duration getExponentialPolicyBaseSleep() {
        return Duration.ofMillis(this.exponentialPolicyBaseSleepInMs);
    }

    public void setExponentialPolicyBaseSleep(Duration duration) {
        this.exponentialPolicyBaseSleepInMs = duration.toMillis();
    }

    public Duration getExponentialPolicyMaxSleep() {
        return Duration.ofMillis(this.exponentialPolicyMaxSleepInMs);
    }

    public void setExponentialPolicyMaxSleep(Duration duration) {
        this.exponentialPolicyMaxSleepInMs = duration.toMillis();
    }

    public long getRetrylimitedRetryInterval() {
        return this.retrylimitedRetryInterval;
    }

    public int getRetrylimitedMaxRetries() {
        return this.retrylimitedMaxRetries;
    }

    public String getRetryPolicy() {
        return this.retryPolicy;
    }

    @ConfigGroup(prefix="hdds.ratis.raft.client")
    public static class RaftConfig {
        @Config(key="async.outstanding-requests.max", defaultValue="32", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Controls the maximum number of outstanding async requests that can be handled by the Standalone as well as Ratis client.")
        private int maxOutstandingRequests = 32;
        @Config(key="rpc.request.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client request (except for watch request). It should be set greater than leader election timeout in Ratis.")
        private long rpcRequestTimeout = Duration.ofSeconds(60L).toMillis();
        @Config(key="rpc.watch.request.timeout", defaultValue="180s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client watch request. Timeout for the watch API in Ratis client to acknowledge a particular request getting replayed to all servers.")
        private long rpcWatchRequestTimeout = Duration.ofSeconds(180L).toMillis();

        public int getMaxOutstandingRequests() {
            return this.maxOutstandingRequests;
        }

        public void setMaxOutstandingRequests(int maxOutstandingRequests) {
            this.maxOutstandingRequests = maxOutstandingRequests;
        }

        public Duration getRpcRequestTimeout() {
            return Duration.ofMillis(this.rpcRequestTimeout);
        }

        public void setRpcRequestTimeout(Duration duration) {
            this.rpcRequestTimeout = duration.toMillis();
        }

        public Duration getRpcWatchRequestTimeout() {
            return Duration.ofMillis(this.rpcWatchRequestTimeout);
        }

        public void setRpcWatchRequestTimeout(Duration duration) {
            this.rpcWatchRequestTimeout = duration.toMillis();
        }
    }
}

