/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public class ExcludeList {
    private final Set<DatanodeDetails> datanodes = new HashSet<DatanodeDetails>();
    private final Set<ContainerID> containerIds = new HashSet<ContainerID>();
    private final Set<PipelineID> pipelineIds = new HashSet<PipelineID>();

    public Set<ContainerID> getContainerIds() {
        return this.containerIds;
    }

    public Set<DatanodeDetails> getDatanodes() {
        return this.datanodes;
    }

    public void addDatanodes(Collection<DatanodeDetails> dns) {
        dns.forEach(dn -> this.addDatanode((DatanodeDetails)dn));
    }

    public void addDatanode(DatanodeDetails dn) {
        this.datanodes.add(dn);
    }

    public void addConatinerId(ContainerID containerId) {
        this.containerIds.add(containerId);
    }

    public void addPipeline(PipelineID pipelineId) {
        this.pipelineIds.add(pipelineId);
    }

    public Set<PipelineID> getPipelineIds() {
        return this.pipelineIds;
    }

    public HddsProtos.ExcludeListProto getProtoBuf() {
        HddsProtos.ExcludeListProto.Builder builder = HddsProtos.ExcludeListProto.newBuilder();
        this.containerIds.forEach(id -> builder.addContainerIds(id.getId()));
        this.datanodes.forEach(dn -> builder.addDatanodes(dn.getUuidString()));
        this.pipelineIds.forEach(pipelineID -> builder.addPipelineIds(pipelineID.getProtobuf()));
        return builder.build();
    }

    public static ExcludeList getFromProtoBuf(HddsProtos.ExcludeListProto excludeListProto) {
        ExcludeList excludeList = new ExcludeList();
        excludeListProto.getContainerIdsList().forEach(id -> excludeList.addConatinerId(ContainerID.valueOf(id)));
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        excludeListProto.getDatanodesList().forEach(dn -> {
            builder.setUuid(UUID.fromString(dn));
            excludeList.addDatanode(builder.build());
        });
        excludeListProto.getPipelineIdsList().forEach(pipelineID -> excludeList.addPipeline(PipelineID.getFromProtobuf(pipelineID)));
        return excludeList;
    }

    public boolean isEmpty() {
        return this.datanodes.isEmpty() && this.containerIds.isEmpty() && this.pipelineIds.isEmpty();
    }

    public void clear() {
        this.datanodes.clear();
        this.containerIds.clear();
        this.pipelineIds.clear();
    }

    public String toString() {
        return "ExcludeList {datanodes = " + this.datanodes + ", containerIds = " + this.containerIds + ", pipelineIds = " + this.pipelineIds + '}';
    }
}

