/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManagerMXBean;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutVersionManager<T extends LayoutFeature>
implements LayoutVersionManager,
LayoutVersionManagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLayoutVersionManager.class);
    private int metadataLayoutVersion;
    private int softwareLayoutVersion;
    @VisibleForTesting
    protected final TreeMap<Integer, T> features = new TreeMap();
    @VisibleForTesting
    protected final Map<String, T> featureMap = new HashMap<String, T>();
    private volatile UpgradeFinalizer.Status currentUpgradeState = UpgradeFinalizer.Status.FINALIZATION_REQUIRED;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(int version, T[] lfs) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.metadataLayoutVersion = version;
            this.initializeFeatures((LayoutFeature[])lfs);
            this.softwareLayoutVersion = this.features.lastKey();
            if (this.softwareIsBehindMetaData()) {
                throw new IOException(String.format("Cannot initialize VersionManager. Metadata layout version (%d) > software layout version (%d)", this.metadataLayoutVersion, this.softwareLayoutVersion));
            }
            if (this.metadataLayoutVersion == this.softwareLayoutVersion) {
                this.currentUpgradeState = UpgradeFinalizer.Status.ALREADY_FINALIZED;
            }
            LayoutFeature mlvFeature = (LayoutFeature)this.features.get(this.metadataLayoutVersion);
            LayoutFeature slvFeature = (LayoutFeature)this.features.get(this.softwareLayoutVersion);
            LOG.info("Initializing Layout version manager with metadata layout = {} (version = {}), software layout = {} (version = {})", new Object[]{mlvFeature, mlvFeature.layoutVersion(), slvFeature, slvFeature.layoutVersion()});
            MBeans.register((String)"LayoutVersionManager", (String)this.getClass().getSimpleName(), (Object)this);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public UpgradeFinalizer.Status getUpgradeState() {
        this.lock.readLock().lock();
        try {
            UpgradeFinalizer.Status status = this.currentUpgradeState;
            return status;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setUpgradeState(UpgradeFinalizer.Status status) {
        this.lock.writeLock().lock();
        try {
            this.currentUpgradeState = status;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void initializeFeatures(T[] lfs) {
        Arrays.stream(lfs).forEach(f -> {
            Preconditions.checkArgument((!this.featureMap.containsKey(f.name()) ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.features.containsKey(f.layoutVersion()) ? 1 : 0) != 0);
            this.features.put(f.layoutVersion(), f);
            this.featureMap.put(f.name(), f);
        });
    }

    public void finalized(T layoutFeature) {
        block4: {
            this.lock.writeLock().lock();
            try {
                if (layoutFeature.layoutVersion() == this.metadataLayoutVersion + 1) {
                    this.metadataLayoutVersion = layoutFeature.layoutVersion();
                    break block4;
                }
                String msgStart = "";
                msgStart = layoutFeature.layoutVersion() < this.metadataLayoutVersion ? "Finalize attempt on a layoutFeature which has already been finalized." : "Finalize attempt on a layoutFeature that is newer than the next feature to be finalized.";
                throw new IllegalArgumentException(msgStart + "Software Layout version: " + this.softwareLayoutVersion + " Feature Layout version: " + layoutFeature.layoutVersion());
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void completeFinalization() {
        this.lock.writeLock().lock();
        try {
            this.currentUpgradeState = UpgradeFinalizer.Status.FINALIZATION_DONE;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean softwareIsBehindMetaData() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.metadataLayoutVersion > this.softwareLayoutVersion;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getMetadataLayoutVersion() {
        this.lock.readLock().lock();
        try {
            int n = this.metadataLayoutVersion;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getSoftwareLayoutVersion() {
        return this.softwareLayoutVersion;
    }

    @Override
    public boolean needsFinalization() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.metadataLayoutVersion < this.softwareLayoutVersion;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isAllowed(LayoutFeature layoutFeature) {
        this.lock.readLock().lock();
        try {
            boolean bl = layoutFeature.layoutVersion() <= this.metadataLayoutVersion;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isAllowed(String featureName) {
        return this.featureMap.containsKey(featureName) && this.isAllowed((LayoutFeature)this.featureMap.get(featureName));
    }

    public T getFeature(String name) {
        return (T)((LayoutFeature)this.featureMap.get(name));
    }

    public Iterable<T> unfinalizedFeatures() {
        this.lock.readLock().lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.features.tailMap(this.metadataLayoutVersion + 1).values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

