/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.util.stream.Stream;
import org.apache.hadoop.hdds.ComponentVersion;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestComponentVersionInvariants {
    public static Stream<Arguments> values() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{DatanodeVersion.values(), DatanodeVersion.DEFAULT_VERSION, DatanodeVersion.FUTURE_VERSION}), Arguments.arguments((Object[])new Object[]{ClientVersion.values(), ClientVersion.DEFAULT_VERSION, ClientVersion.FUTURE_VERSION}), Arguments.arguments((Object[])new Object[]{OzoneManagerVersion.values(), OzoneManagerVersion.DEFAULT_VERSION, OzoneManagerVersion.FUTURE_VERSION}));
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    public void testFutureVersionHasTheHighestOrdinal(ComponentVersion[] values, ComponentVersion defaultValue, ComponentVersion futureValue) {
        Assertions.assertEquals((Object)values[values.length - 1], (Object)futureValue);
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    public void testFuturVersionHasMinusOneAsProtoRepresentation(ComponentVersion[] values, ComponentVersion defaultValue, ComponentVersion futureValue) {
        Assertions.assertEquals((int)-1, (int)futureValue.toProtoValue());
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    public void testDefaultVersionHasZeroAsProtoRepresentation(ComponentVersion[] values, ComponentVersion defaultValue, ComponentVersion futureValue) {
        Assertions.assertEquals((int)0, (int)defaultValue.toProtoValue());
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    public void testAssignedProtoRepresentations(ComponentVersion[] values, ComponentVersion defaultValue, ComponentVersion futureValue) {
        int startValue = defaultValue.toProtoValue();
        for (int i = 0; i < values.length - 1; ++i) {
            Assertions.assertEquals((int)values[i].toProtoValue(), (int)startValue++);
        }
        Assertions.assertEquals((int)values.length, (int)(++startValue));
    }
}

