/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHddsUtils {
    private static final String REDACTED_TEXT = "<redacted>";
    private static final String ORIGINAL_VALUE = "Hello, World!";
    private static final String SENSITIVE_CONFIG_KEYS = "hadoop.security.sensitive-config-keys";

    @Test
    public void testGetHostName() {
        Assertions.assertEquals(Optional.of("localhost"), (Object)HddsUtils.getHostName((String)"localhost:1234"));
        Assertions.assertEquals(Optional.of("localhost"), (Object)HddsUtils.getHostName((String)"localhost"));
        Assertions.assertEquals(Optional.empty(), (Object)HddsUtils.getHostName((String)":1234"));
    }

    @Test
    public void validatePath() {
        HddsUtils.validatePath((Path)Paths.get("/", new String[0]), (Path)Paths.get("/", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a", new String[0]), (Path)Paths.get("/", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/b", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/b/c", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/../a/b", new String[0]), (Path)Paths.get("/a", new String[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/b/c", new String[0]), (Path)Paths.get("/a", new String[0])));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/", new String[0]), (Path)Paths.get("/a", new String[0])));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/a/..", new String[0]), (Path)Paths.get("/a", new String[0])));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/a/../b", new String[0]), (Path)Paths.get("/a", new String[0])));
    }

    @Test
    public void testGetSCMAddresses() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.setStrings("ozone.scm.names", new String[]{"1.2.3.4"});
        Collection addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertEquals((int)1, (int)addresses.size());
        InetSocketAddress addr = (InetSocketAddress)addresses.iterator().next();
        Assertions.assertEquals((Object)"1.2.3.4", (Object)addr.getHostName());
        Assertions.assertEquals((int)9861, (int)addr.getPort());
        conf.setStrings("ozone.scm.names", new String[]{"scm1"});
        addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertEquals((int)1, (int)addresses.size());
        addr = (InetSocketAddress)addresses.iterator().next();
        Assertions.assertEquals((Object)"scm1", (Object)addr.getHostName());
        Assertions.assertEquals((int)9861, (int)addr.getPort());
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234"});
        addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertEquals((int)1, (int)addresses.size());
        addr = (InetSocketAddress)addresses.iterator().next();
        Assertions.assertEquals((Object)"scm1", (Object)addr.getHostName());
        Assertions.assertEquals((int)1234, (int)addr.getPort());
        HashMap<String, Integer> hostsAndPorts = new HashMap<String, Integer>();
        hostsAndPorts.put("scm1", 1234);
        hostsAndPorts.put("scm2", 2345);
        hostsAndPorts.put("scm3", 3456);
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234,scm2:2345,scm3:3456"});
        addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertEquals((int)3, (int)addresses.size());
        Iterator it = addresses.iterator();
        HashMap expected1 = new HashMap(hostsAndPorts);
        while (it.hasNext()) {
            InetSocketAddress current = (InetSocketAddress)it.next();
            Assertions.assertTrue((boolean)expected1.remove(current.getHostName(), current.getPort()));
        }
        Assertions.assertTrue((boolean)expected1.isEmpty());
        conf.setStrings("ozone.scm.names", new String[]{" scm1:1234, scm2:2345 , scm3:3456 "});
        addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertEquals((int)3, (int)addresses.size());
        it = addresses.iterator();
        HashMap expected2 = new HashMap(hostsAndPorts);
        while (it.hasNext()) {
            InetSocketAddress current = (InetSocketAddress)it.next();
            Assertions.assertTrue((boolean)expected2.remove(current.getHostName(), current.getPort()));
        }
        Assertions.assertTrue((boolean)expected2.isEmpty());
        conf.setStrings("ozone.scm.names", new String[]{""});
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf), (String)"Empty value should cause an IllegalArgumentException");
        conf.setStrings("ozone.scm.names", new String[]{"s..x..:1234"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf), (String)"An invalid hostname should cause an IllegalArgumentException");
        conf.setStrings("ozone.scm.names", new String[]{"scm:xyz"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf), (String)"An invalid port should cause an IllegalArgumentException");
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234, scm:xyz"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf), (String)"An invalid value should cause an IllegalArgumentException");
    }

    @Test
    public void testGetSCMAddressesWithHAConfig() {
        OzoneConfiguration conf = new OzoneConfiguration();
        String scmServiceId = "scmserviceId";
        String[] nodes = new String[]{"scm1", "scm2", "scm3"};
        conf.set("ozone.scm.service.ids", scmServiceId);
        conf.set("ozone.scm.nodes." + scmServiceId, "scm1,scm2,scm3");
        int port = 9880;
        ArrayList<String> expected = new ArrayList<String>();
        for (String nodeId : nodes) {
            conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{scmServiceId, nodeId}), "scm");
            conf.setInt(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{scmServiceId, nodeId}), ++port);
            expected.add("scm:" + port);
        }
        Collection scmAddressList = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)conf);
        Assertions.assertNotNull((Object)scmAddressList);
        Assertions.assertEquals((int)3, (int)scmAddressList.size());
        for (InetSocketAddress next : scmAddressList) {
            expected.remove(next.getHostName() + ":" + next.getPort());
        }
        Assertions.assertEquals((int)0, (int)expected.size());
    }

    @Test
    public void testGetNumberFromConfigKeys() {
        String testnum1 = "8";
        String testnum2 = "7";
        String serviceId = "id1";
        String nodeId = "scm1";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.pipeline.owner.container.count", "8");
        Assertions.assertEquals((int)Integer.parseInt("8"), (int)HddsUtils.getNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.pipeline.owner.container.count"}).orElse(0));
        Assertions.assertEquals((int)Integer.parseInt("8"), (int)HddsUtils.getNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{"id1", "scm1"}), "ozone.scm.pipeline.owner.container.count"}).orElse(0));
        conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{"id1", "scm1"}), "7");
        Assertions.assertEquals((int)Integer.parseInt("7"), (int)HddsUtils.getNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{"id1", "scm1"}), "ozone.scm.pipeline.owner.container.count"}).orElse(0));
    }

    @Test
    public void testRedactSensitivePropsForLogging() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set(SENSITIVE_CONFIG_KEYS, String.join((CharSequence)"\n", "password$", "key$"));
        conf.set("ozone.test.password", ORIGINAL_VALUE);
        conf.set("hdds.test.secret.key", ORIGINAL_VALUE);
        conf.set("ozone.normal.config", ORIGINAL_VALUE);
        Map processedConf = HddsUtils.processForLogging((OzoneConfiguration)conf);
        Assertions.assertEquals(processedConf.get("ozone.test.password"), (Object)REDACTED_TEXT);
        Assertions.assertEquals(processedConf.get("hdds.test.secret.key"), (Object)REDACTED_TEXT);
        Assertions.assertEquals(processedConf.get("ozone.normal.config"), (Object)ORIGINAL_VALUE);
    }
}

