/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.stream.Stream;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestReplicationConfig {
    private static final int MB = 0x100000;
    private static final int KB = 1024;

    public static Stream<Arguments> replicaType() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"RATIS", "ONE", RatisReplicationConfig.class}), Arguments.arguments((Object[])new Object[]{"RATIS", "THREE", RatisReplicationConfig.class}), Arguments.arguments((Object[])new Object[]{"STAND_ALONE", "ONE", StandaloneReplicationConfig.class}), Arguments.arguments((Object[])new Object[]{"STAND_ALONE", "THREE", StandaloneReplicationConfig.class}));
    }

    public static Stream<Arguments> ecType() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"RS", 3, 2, 0x100000}), Arguments.arguments((Object[])new Object[]{"RS", 3, 2, 0x200000}), Arguments.arguments((Object[])new Object[]{"RS", 6, 3, 0x100000}), Arguments.arguments((Object[])new Object[]{"RS", 6, 3, 0x200000}), Arguments.arguments((Object[])new Object[]{"RS", 10, 4, 0x100000}), Arguments.arguments((Object[])new Object[]{"RS", 10, 4, 0x200000}));
    }

    @Test
    void testGetDefaultShouldReturnRatisThreeIfNotSetClientSide() {
        OzoneConfiguration conf = new OzoneConfiguration();
        ReplicationConfig replicationConfig = ReplicationConfig.getDefault((ConfigurationSource)conf);
        this.validate(replicationConfig, ReplicationType.RATIS, ReplicationFactor.THREE, RatisReplicationConfig.class);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testGetDefaultShouldCreateReplicationConfFromConfValues(String type, String factor, Class<?> replicationConfigClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.replication.type", type);
        conf.set("ozone.replication", factor);
        ReplicationConfig replicationConfig = ReplicationConfig.getDefault((ConfigurationSource)conf);
        this.validate(replicationConfig, ReplicationType.valueOf((String)type), ReplicationFactor.valueOf((String)factor), replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"ecType"})
    void testGetDefaultShouldCreateECReplicationConfFromConfValues(String codec, int data, int parity, int chunkSize) {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.replication.type", "EC");
        conf.set("ozone.replication", this.ecDescriptor(codec, data, parity, chunkSize));
        ReplicationConfig replicationConfig = ReplicationConfig.getDefault((ConfigurationSource)conf);
        this.validate(replicationConfig, ECReplicationConfig.EcCodec.valueOf((String)codec), data, parity, chunkSize);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void deserialize(String type, String factor, Class<?> replicationConfigClass) {
        ReplicationConfig replicationConfig = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.valueOf((String)type), (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.valueOf((String)factor));
        this.validate(replicationConfig, ReplicationType.valueOf((String)type), ReplicationFactor.valueOf((String)factor), replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"ecType"})
    void deserializeEC(String codec, int data, int parity, int chunkSize) {
        HddsProtos.ECReplicationConfig proto = HddsProtos.ECReplicationConfig.newBuilder().setCodec(codec).setData(data).setParity(parity).setEcChunkSize(chunkSize).build();
        ReplicationConfig config = ReplicationConfig.fromProto((HddsProtos.ReplicationType)HddsProtos.ReplicationType.EC, null, (HddsProtos.ECReplicationConfig)proto);
        this.validate(config, ECReplicationConfig.EcCodec.valueOf((String)codec), data, parity, chunkSize);
    }

    @ParameterizedTest
    @MethodSource(value={"ecType"})
    void testECReplicationConfigGetReplication(String codec, int data, int parity, int chunkSize) {
        HddsProtos.ECReplicationConfig proto = HddsProtos.ECReplicationConfig.newBuilder().setCodec(codec).setData(data).setParity(parity).setEcChunkSize(chunkSize).build();
        ReplicationConfig config = ReplicationConfig.fromProto((HddsProtos.ReplicationType)HddsProtos.ReplicationType.EC, null, (HddsProtos.ECReplicationConfig)proto);
        Assertions.assertEquals((Object)(ECReplicationConfig.EcCodec.valueOf((String)codec) + "-" + data + "-" + parity + "-" + chunkSize / 1024 + "k"), (Object)config.getReplication());
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testReplicationConfigGetReplication(String type, String factor, Class<?> replicationConfigClass) {
        ReplicationConfig replicationConfig = ReplicationConfig.fromTypeAndFactor((ReplicationType)ReplicationType.valueOf((String)type), (ReplicationFactor)ReplicationFactor.valueOf((String)factor));
        Assertions.assertEquals((Object)factor, (Object)replicationConfig.getReplication());
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void fromJavaObjects(String type, String factor, Class<?> replicationConfigClass) {
        ReplicationConfig replicationConfig = ReplicationConfig.fromTypeAndFactor((ReplicationType)ReplicationType.valueOf((String)type), (ReplicationFactor)ReplicationFactor.valueOf((String)factor));
        this.validate(replicationConfig, ReplicationType.valueOf((String)type), ReplicationFactor.valueOf((String)factor), replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testParseFromTypeAndFactorAsString(String type, String factor, Class<?> replicationConfigClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)type), (String)factor, (ConfigurationSource)conf);
        this.validate(replicationConfig, ReplicationType.valueOf((String)type), ReplicationFactor.valueOf((String)factor), replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testParseFromTypeAndFactorAsStringifiedInteger(String type, String factor, Class<?> replicationConfigClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        String f = factor.equals("ONE") ? "1" : (factor.equals("THREE") ? "3" : "Test adjustment needed!");
        ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)type), (String)f, (ConfigurationSource)conf);
        this.validate(replicationConfig, ReplicationType.valueOf((String)type), ReplicationFactor.valueOf((String)factor), replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"ecType"})
    void testParseECReplicationConfigFromString(String codec, int data, int parity, int chunkSize) {
        OzoneConfiguration conf = new OzoneConfiguration();
        ReplicationConfig repConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.EC, (String)this.ecDescriptor(codec, data, parity, chunkSize), (ConfigurationSource)conf);
        this.validate(repConfig, ECReplicationConfig.EcCodec.valueOf((String)codec), data, parity, chunkSize);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testAdjustReplication(String type, String factor, Class<?> replicationConfigClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)type), (String)factor, (ConfigurationSource)conf);
        this.validate(ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)3, (ConfigurationSource)conf), ReplicationType.valueOf((String)type), ReplicationFactor.THREE, replicationConfigClass);
        this.validate(ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)1, (ConfigurationSource)conf), ReplicationType.valueOf((String)type), ReplicationFactor.ONE, replicationConfigClass);
    }

    @ParameterizedTest
    @MethodSource(value={"ecType"})
    void testAdjustECReplication(String codec, int data, int parity, int chunkSize) {
        OzoneConfiguration conf = new OzoneConfiguration();
        ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.EC, (String)this.ecDescriptor(codec, data, parity, chunkSize), (ConfigurationSource)conf);
        this.validate(ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)3, (ConfigurationSource)conf), ECReplicationConfig.EcCodec.valueOf((String)codec), data, parity, chunkSize);
        this.validate(ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)1, (ConfigurationSource)conf), ECReplicationConfig.EcCodec.valueOf((String)codec), data, parity, chunkSize);
    }

    @ParameterizedTest
    @MethodSource(value={"replicaType"})
    void testValidationBasedOnConfig(String type, String factor, Class<?> replicationConfigClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.replication.allowed-configs", "^STANDALONE/ONE|RATIS/THREE$");
        conf.set("ozone.replication", factor);
        conf.set("ozone.replication.type", type);
        ReplicationType replicationType = ReplicationType.valueOf((String)type);
        if (type.equals("RATIS") && factor.equals("THREE") || type.equals("STAND_ALONE") && factor.equals("ONE")) {
            ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)replicationType, (String)factor, (ConfigurationSource)conf);
            if (type.equals("RATIS")) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)1, (ConfigurationSource)conf));
            } else {
                Assertions.assertThrows(IllegalArgumentException.class, () -> ReplicationConfig.adjustReplication((ReplicationConfig)replicationConfig, (short)3, (ConfigurationSource)conf));
            }
            ReplicationConfig.getDefault((ConfigurationSource)conf);
        } else {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ReplicationConfig.parse((ReplicationType)replicationType, (String)factor, (ConfigurationSource)conf));
            Assertions.assertThrows(IllegalArgumentException.class, () -> ReplicationConfig.getDefault((ConfigurationSource)conf));
        }
        ReplicationConfig.fromTypeAndFactor((ReplicationType)ReplicationType.valueOf((String)type), (ReplicationFactor)ReplicationFactor.valueOf((String)factor));
        ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.valueOf((String)type), (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.valueOf((String)factor));
        Assertions.assertThrows(RuntimeException.class, () -> ReplicationConfig.parse((ReplicationType)ReplicationType.CHAINED, (String)"", (ConfigurationSource)conf));
    }

    private void validate(ReplicationConfig replicationConfig, ReplicationType expectedType, ReplicationFactor expectedFactor, Class<?> expectedReplicationConfigClass) {
        Assertions.assertSame(expectedReplicationConfigClass, replicationConfig.getClass());
        Assertions.assertEquals((Object)expectedType.name(), (Object)replicationConfig.getReplicationType().name());
        Assertions.assertEquals((int)expectedFactor.getValue(), (int)replicationConfig.getRequiredNodes());
        Assertions.assertEquals((Object)expectedFactor.name(), (Object)((ReplicatedReplicationConfig)replicationConfig).getReplicationFactor().name());
    }

    private void validate(ReplicationConfig replicationConfig, ECReplicationConfig.EcCodec expectedCodec, int expectedData, int expectedParity, int expectedChunkSize) {
        Assertions.assertSame(ECReplicationConfig.class, replicationConfig.getClass());
        Assertions.assertEquals((Object)HddsProtos.ReplicationType.EC, (Object)replicationConfig.getReplicationType());
        ECReplicationConfig ecReplicationConfig = (ECReplicationConfig)replicationConfig;
        Assertions.assertEquals((Object)expectedCodec, (Object)ecReplicationConfig.getCodec());
        Assertions.assertEquals((int)expectedData, (int)ecReplicationConfig.getData());
        Assertions.assertEquals((int)expectedParity, (int)ecReplicationConfig.getParity());
        Assertions.assertEquals((int)expectedChunkSize, (int)ecReplicationConfig.getEcChunkSize());
        Assertions.assertEquals((int)(expectedData + expectedParity), (int)replicationConfig.getRequiredNodes());
    }

    private String ecDescriptor(String codec, int data, int parity, int chunkSize) {
        return codec.toUpperCase() + "-" + data + "-" + parity + "-" + chunkSize / 1024 + "k";
    }
}

