/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.SimpleConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGeneratedConfigurationOverwrite {
    private final Path generatedConfigurationPath = Paths.get("target/test-classes/ozone-default-generated.xml", new String[0]);
    private final Path generatedConfigurationPathBak = Paths.get("target/test-classes/ozone-default-generated.xml.bak", new String[0]);
    private OzoneConfiguration conf;

    @BeforeEach
    public void overwriteConfigFile() throws Exception {
        Files.move(this.generatedConfigurationPath, this.generatedConfigurationPathBak, new CopyOption[0]);
        this.conf = new OzoneConfiguration();
    }

    @AfterEach
    public void recoverConfigFile() throws Exception {
        Files.move(this.generatedConfigurationPathBak, this.generatedConfigurationPath, new CopyOption[0]);
    }

    @Test
    public void getConfigurationObject() {
        Assertions.assertNotNull((Object)((SimpleConfiguration)((Object)this.conf.getObject(SimpleConfiguration.class))).getBindHost());
        Assertions.assertNotEquals((int)((SimpleConfiguration)((Object)this.conf.getObject(SimpleConfiguration.class))).getPort(), (int)0);
        Assertions.assertNotEquals((long)((SimpleConfiguration)((Object)this.conf.getObject(SimpleConfiguration.class))).getWaitTime(), (long)0L);
    }
}

