/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.OptionalLong;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.fs.MockSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SaveSpaceUsageToFile;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.ozone.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSaveSpaceUsageToFile {
    private static final File DIR = GenericTestUtils.getTestDir((String)TestSaveSpaceUsageToFile.class.getSimpleName());
    private static final Duration LONG_EXPIRY = Duration.ofMinutes(15L);
    private static final SpaceUsageSource VALID_USAGE_SOURCE = MockSpaceUsageSource.fixed(123L, 81L);
    private File file;

    @BeforeEach
    public void setup() {
        FileUtil.fullyDelete((File)DIR);
        Assertions.assertTrue((boolean)DIR.mkdirs());
        this.file = new File(DIR, "space_usage.txt");
    }

    @AfterEach
    public void cleanup() {
        FileUtil.fullyDelete((File)DIR);
    }

    @Test
    public void persistsValidValue() {
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        subject.save(VALID_USAGE_SOURCE);
        OptionalLong savedValue = subject.load();
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertTrue((boolean)savedValue.isPresent());
        Assertions.assertEquals((long)VALID_USAGE_SOURCE.getUsedSpace(), (long)savedValue.getAsLong());
    }

    @Test
    public void doesNotSaveInvalidValue() {
        SpaceUsageSource source = MockSpaceUsageSource.fixed(123L, 123L);
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        subject.save(source);
        OptionalLong savedValue = subject.load();
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)savedValue.isPresent());
    }

    @Test
    public void doesNotLoadExpiredValue() throws Exception {
        Duration shortExpiry = Duration.ofMillis(5L);
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, shortExpiry);
        subject.save(VALID_USAGE_SOURCE);
        Instant expired = Instant.now().plus(shortExpiry);
        GenericTestUtils.waitFor(() -> Instant.now().isAfter(expired), (int)10, (int)1000);
        OptionalLong savedValue = subject.load();
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)savedValue.isPresent());
    }

    @Test
    public void doesNotLoadIfTimeMissing() throws IOException {
        this.saveToFile(Long.toString(VALID_USAGE_SOURCE.getUsedSpace()));
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        OptionalLong savedValue = subject.load();
        Assertions.assertFalse((boolean)savedValue.isPresent());
    }

    @Test
    public void doesNotLoadIfFileMissing() {
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        OptionalLong savedValue = subject.load();
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)savedValue.isPresent());
    }

    @Test
    public void doesNotLoadGarbage() throws IOException {
        this.saveToFile("garbage 456");
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        OptionalLong savedValue = subject.load();
        Assertions.assertFalse((boolean)savedValue.isPresent());
    }

    @Test
    public void overwritesExistingFile() throws IOException {
        this.saveToFile("456 " + Instant.now().toEpochMilli());
        SaveSpaceUsageToFile subject = new SaveSpaceUsageToFile(this.file, LONG_EXPIRY);
        subject.save(VALID_USAGE_SOURCE);
        OptionalLong savedValue = subject.load();
        Assertions.assertTrue((boolean)savedValue.isPresent());
        Assertions.assertEquals((long)VALID_USAGE_SOURCE.getUsedSpace(), (long)savedValue.getAsLong());
    }

    private void saveToFile(String content) throws IOException {
        FileUtils.writeStringToFile((File)this.file, (String)content, (Charset)StandardCharsets.UTF_8);
    }
}

