/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.ClientVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDatanodeDetails {
    @Test
    public void protoIncludesNewPortsOnlyForV1() {
        DatanodeDetails subject = MockDatanodeDetails.randomDatanodeDetails();
        HddsProtos.DatanodeDetailsProto proto = subject.toProto(ClientVersion.DEFAULT_VERSION.toProtoValue());
        TestDatanodeDetails.assertPorts(proto, DatanodeDetails.Port.Name.V0_PORTS);
        HddsProtos.DatanodeDetailsProto protoV1 = subject.toProto(ClientVersion.VERSION_HANDLES_UNKNOWN_DN_PORTS.toProtoValue());
        TestDatanodeDetails.assertPorts(protoV1, DatanodeDetails.Port.Name.ALL_PORTS);
    }

    public static void assertPorts(HddsProtos.DatanodeDetailsProto dn, Set<DatanodeDetails.Port.Name> expectedPorts) {
        Assertions.assertEquals((int)expectedPorts.size(), (int)dn.getPortsCount());
        for (HddsProtos.Port port : dn.getPortsList()) {
            try {
                Assertions.assertTrue((boolean)expectedPorts.contains(DatanodeDetails.Port.Name.valueOf((String)port.getName())));
            }
            catch (IllegalArgumentException e) {
                Assertions.fail((String)("Unknown port: " + port.getName()));
            }
        }
    }
}

