/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestServerNotLeaderExceptionMessageParsing {
    TestServerNotLeaderExceptionMessageParsing() {
    }

    @Test
    public void testServerNotLeaderException() {
        String msg = "Server:cf0bc565-a41b-4784-a24d-3048d5a5b013 is not the leader. Suggested leader is Server:scm5-3.scm5.root.hwx.site:9863";
        ServerNotLeaderException snle = new ServerNotLeaderException("Server:cf0bc565-a41b-4784-a24d-3048d5a5b013 is not the leader. Suggested leader is Server:scm5-3.scm5.root.hwx.site:9863");
        Assertions.assertEquals((Object)snle.getSuggestedLeader(), (Object)"scm5-3.scm5.root.hwx.site:9863");
        String message = "Server:7fdd7170-75cc-4e11-b343-c2657c2f2f39 is not the leader.Suggested leader is Server:scm5-3.scm5.root.hwx.site:9863 \nat org.apache.hadoop.hdds.ratis.ServerNotLeaderException.convertToNotLeaderException(ServerNotLeaderException.java:96)";
        snle = new ServerNotLeaderException(message);
        Assertions.assertEquals((Object)"scm5-3.scm5.root.hwx.site:9863", (Object)snle.getSuggestedLeader());
        message = "Server:7fdd7170-75cc-4e11-b343-c2657c2f2f39 is not the leader.Suggested leader is Server:localhost:98634 \nat org.apache.hadoop.hdds.ratis.ServerNotLeaderException.convertToNotLeaderException(ServerNotLeaderException.java:96)";
        snle = new ServerNotLeaderException(message);
        Assertions.assertEquals((Object)"localhost:98634", (Object)snle.getSuggestedLeader());
        message = "Server:7fdd7170-75cc-4e11-b343-c2657c2f2f39 is not the leader.Suggested leader is Server::98634 \nat org.apache.hadoop.hdds.ratis.ServerNotLeaderException.convertToNotLeaderException(ServerNotLeaderException.java:96)";
        snle = new ServerNotLeaderException(message);
        Assertions.assertEquals(null, (Object)snle.getSuggestedLeader());
        message = "Server:7fdd7170-75cc-4e11-b343-c2657c2f2f39 is not the leader.Suggested leader is Server:localhost:98634:8988 \nat org.apache.hadoop.hdds.ratis.ServerNotLeaderException.convertToNotLeaderException(ServerNotLeaderException.java:96)";
        snle = new ServerNotLeaderException(message);
        Assertions.assertEquals((Object)"localhost:98634", (Object)snle.getSuggestedLeader());
        message = "Server:7fdd7170-75cc-4e11-b343-c2657c2f2f39 is not the leader.Suggested leader is Server:localhost \nat org.apache.hadoop.hdds.ratis.ServerNotLeaderException.convertToNotLeaderException(ServerNotLeaderException.java)";
        snle = new ServerNotLeaderException(message);
        Assertions.assertEquals(null, (Object)snle.getSuggestedLeader());
    }
}

