/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.conf;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRatisClientConfig {
    TestRatisClientConfig() {
    }

    @Test
    void defaults() {
        RatisClientConfig fromConfig = (RatisClientConfig)new OzoneConfiguration().getObject(RatisClientConfig.class);
        RatisClientConfig subject = new RatisClientConfig();
        Assertions.assertEquals((Object)fromConfig.getExponentialPolicyBaseSleep(), (Object)subject.getExponentialPolicyBaseSleep());
        Assertions.assertEquals((Object)fromConfig.getExponentialPolicyMaxSleep(), (Object)subject.getExponentialPolicyMaxSleep());
        Assertions.assertEquals((Object)fromConfig.getWatchRequestTimeout(), (Object)subject.getWatchRequestTimeout());
        Assertions.assertEquals((Object)fromConfig.getWriteRequestTimeout(), (Object)subject.getWriteRequestTimeout());
    }

    @Test
    void setAndGet() {
        RatisClientConfig subject = new RatisClientConfig();
        Duration baseSleep = Duration.ofSeconds(12L);
        Duration maxSleep = Duration.ofMinutes(2L);
        Duration watchRequestTimeout = Duration.ofMillis(555L);
        Duration writeRequestTimeout = Duration.ofMillis(444L);
        subject.setExponentialPolicyBaseSleep(baseSleep);
        subject.setExponentialPolicyMaxSleep(maxSleep);
        subject.setWatchRequestTimeout(watchRequestTimeout);
        subject.setWriteRequestTimeout(writeRequestTimeout);
        Assertions.assertEquals((Object)baseSleep, (Object)subject.getExponentialPolicyBaseSleep());
        Assertions.assertEquals((Object)maxSleep, (Object)subject.getExponentialPolicyMaxSleep());
        Assertions.assertEquals((Object)watchRequestTimeout, (Object)subject.getWatchRequestTimeout());
        Assertions.assertEquals((Object)writeRequestTimeout, (Object)subject.getWriteRequestTimeout());
    }
}

