/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.util.Collection;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSCMHAUtils {
    TestSCMHAUtils() {
    }

    @Test
    void testRemoveSelfId() {
        String service = "mySCM";
        String selfId = "scm3";
        OzoneConfiguration input = new OzoneConfiguration();
        input.set("ozone.scm.service.ids", service);
        input.set("ozone.scm.nodes." + service, "scm1,scm2," + selfId);
        input.set("ozone.scm.node.id", selfId);
        OzoneConfiguration output = SCMHAUtils.removeSelfId((OzoneConfiguration)input, (String)selfId);
        Collection nodesWithoutSelf = SCMHAUtils.getSCMNodeIds((ConfigurationSource)output, (String)service);
        Assertions.assertEquals((int)2, (int)nodesWithoutSelf.size());
        Assertions.assertFalse((boolean)nodesWithoutSelf.contains(selfId));
    }
}

