/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestContainerReplicaInfo {
    @Test
    public void testObjectCreatedFromProto() {
        HddsProtos.SCMContainerReplicaProto proto = HddsProtos.SCMContainerReplicaProto.newBuilder().setKeyCount(10L).setBytesUsed(12345L).setContainerID(567L).setPlaceOfBirth(UUID.randomUUID().toString()).setSequenceID(5L).setDatanodeDetails(MockDatanodeDetails.randomDatanodeDetails().getProtoBufMessage()).setState("OPEN").build();
        ContainerReplicaInfo info = ContainerReplicaInfo.fromProto((HddsProtos.SCMContainerReplicaProto)proto);
        Assertions.assertEquals((long)proto.getContainerID(), (long)info.getContainerID());
        Assertions.assertEquals((long)proto.getBytesUsed(), (long)info.getBytesUsed());
        Assertions.assertEquals((long)proto.getKeyCount(), (long)info.getKeyCount());
        Assertions.assertEquals((Object)proto.getPlaceOfBirth(), (Object)info.getPlaceOfBirth().toString());
        Assertions.assertEquals((Object)DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)proto.getDatanodeDetails()), (Object)info.getDatanodeDetails());
        Assertions.assertEquals((long)proto.getSequenceID(), (long)info.getSequenceId());
        Assertions.assertEquals((Object)proto.getState(), (Object)info.getState());
        Assertions.assertEquals((int)-1, (int)info.getReplicaIndex());
    }

    @Test
    public void testObjectCreatedFromProtoWithReplicaIndedx() {
        HddsProtos.SCMContainerReplicaProto proto = HddsProtos.SCMContainerReplicaProto.newBuilder().setKeyCount(10L).setBytesUsed(12345L).setContainerID(567L).setPlaceOfBirth(UUID.randomUUID().toString()).setSequenceID(5L).setDatanodeDetails(MockDatanodeDetails.randomDatanodeDetails().getProtoBufMessage()).setState("OPEN").setReplicaIndex(4L).build();
        ContainerReplicaInfo info = ContainerReplicaInfo.fromProto((HddsProtos.SCMContainerReplicaProto)proto);
        Assertions.assertEquals((long)proto.getContainerID(), (long)info.getContainerID());
        Assertions.assertEquals((long)proto.getBytesUsed(), (long)info.getBytesUsed());
        Assertions.assertEquals((long)proto.getKeyCount(), (long)info.getKeyCount());
        Assertions.assertEquals((Object)proto.getPlaceOfBirth(), (Object)info.getPlaceOfBirth().toString());
        Assertions.assertEquals((Object)DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)proto.getDatanodeDetails()), (Object)info.getDatanodeDetails());
        Assertions.assertEquals((long)proto.getSequenceID(), (long)info.getSequenceId());
        Assertions.assertEquals((Object)proto.getState(), (Object)info.getState());
        Assertions.assertEquals((int)4, (int)info.getReplicaIndex());
    }
}

