/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestReplicationManagerReport {
    private ReplicationManagerReport report;

    @BeforeEach
    public void setup() {
        this.report = new ReplicationManagerReport();
    }

    @Test
    public void testMetricCanBeIncremented() {
        this.report.increment(ReplicationManagerReport.HealthState.UNDER_REPLICATED);
        this.report.increment(ReplicationManagerReport.HealthState.UNDER_REPLICATED);
        this.report.increment(ReplicationManagerReport.HealthState.OVER_REPLICATED);
        this.report.increment(HddsProtos.LifeCycleState.OPEN);
        this.report.increment(HddsProtos.LifeCycleState.CLOSED);
        this.report.increment(HddsProtos.LifeCycleState.CLOSED);
        Assertions.assertEquals((long)2L, (long)this.report.getStat(ReplicationManagerReport.HealthState.UNDER_REPLICATED));
        Assertions.assertEquals((long)1L, (long)this.report.getStat(ReplicationManagerReport.HealthState.OVER_REPLICATED));
        Assertions.assertEquals((long)0L, (long)this.report.getStat(ReplicationManagerReport.HealthState.MIS_REPLICATED));
        Assertions.assertEquals((long)1L, (long)this.report.getStat(HddsProtos.LifeCycleState.OPEN));
        Assertions.assertEquals((long)2L, (long)this.report.getStat(HddsProtos.LifeCycleState.CLOSED));
        Assertions.assertEquals((long)0L, (long)this.report.getStat(HddsProtos.LifeCycleState.QUASI_CLOSED));
    }

    @Test
    public void testJsonOutput() throws IOException {
        this.report.increment(HddsProtos.LifeCycleState.OPEN);
        this.report.increment(HddsProtos.LifeCycleState.CLOSED);
        this.report.increment(HddsProtos.LifeCycleState.CLOSED);
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, new ContainerID(1L));
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, new ContainerID(2L));
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, new ContainerID(3L));
        this.report.setComplete();
        String jsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)this.report);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonString);
        Assertions.assertTrue((json.get("reportTimeStamp").longValue() > 0L ? 1 : 0) != 0);
        JsonNode stats = json.get("stats");
        Assertions.assertEquals((long)1L, (long)stats.get("OPEN").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("CLOSING").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("QUASI_CLOSED").longValue());
        Assertions.assertEquals((long)2L, (long)stats.get("CLOSED").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("DELETING").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("DELETED").longValue());
        Assertions.assertEquals((long)2L, (long)stats.get("UNDER_REPLICATED").longValue());
        Assertions.assertEquals((long)1L, (long)stats.get("OVER_REPLICATED").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("MIS_REPLICATED").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("MISSING").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("UNHEALTHY").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("EMPTY").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("OPEN_UNHEALTHY").longValue());
        Assertions.assertEquals((long)0L, (long)stats.get("QUASI_CLOSED_STUCK").longValue());
        JsonNode samples = json.get("samples");
        Assertions.assertEquals((Object)JsonNodeType.ARRAY, (Object)samples.get("UNDER_REPLICATED").getNodeType());
        Assertions.assertEquals((long)1L, (long)samples.get("UNDER_REPLICATED").get(0).longValue());
        Assertions.assertEquals((long)2L, (long)samples.get("UNDER_REPLICATED").get(1).longValue());
        Assertions.assertEquals((long)3L, (long)samples.get("OVER_REPLICATED").get(0).longValue());
    }

    @Test
    public void testContainerIDsCanBeSampled() {
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, new ContainerID(1L));
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, new ContainerID(2L));
        this.report.incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, new ContainerID(3L));
        Assertions.assertEquals((long)2L, (long)this.report.getStat(ReplicationManagerReport.HealthState.UNDER_REPLICATED));
        Assertions.assertEquals((long)1L, (long)this.report.getStat(ReplicationManagerReport.HealthState.OVER_REPLICATED));
        Assertions.assertEquals((long)0L, (long)this.report.getStat(ReplicationManagerReport.HealthState.MIS_REPLICATED));
        List sample = this.report.getSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED);
        Assertions.assertEquals((Object)new ContainerID(1L), sample.get(0));
        Assertions.assertEquals((Object)new ContainerID(2L), sample.get(1));
        Assertions.assertEquals((int)2, (int)sample.size());
        sample = this.report.getSample(ReplicationManagerReport.HealthState.OVER_REPLICATED);
        Assertions.assertEquals((Object)new ContainerID(3L), sample.get(0));
        Assertions.assertEquals((int)1, (int)sample.size());
        sample = this.report.getSample(ReplicationManagerReport.HealthState.MIS_REPLICATED);
        Assertions.assertEquals((int)0, (int)sample.size());
    }

    @Test
    public void testSamplesAreLimited() {
        for (int i = 0; i < 200; ++i) {
            this.report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, new ContainerID((long)i));
        }
        List sample = this.report.getSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED);
        Assertions.assertEquals((int)100, (int)sample.size());
        for (int i = 0; i < 100; ++i) {
            Assertions.assertEquals((Object)new ContainerID((long)i), sample.get(i));
        }
    }

    @Test
    public void testSerializeToProtoAndBack() {
        this.report.setTimestamp(12345L);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (HddsProtos.LifeCycleState lifeCycleState : HddsProtos.LifeCycleState.values()) {
            this.report.setStat(lifeCycleState.toString(), (long)((Random)rand).nextInt(Integer.MAX_VALUE));
        }
        for (HddsProtos.LifeCycleState lifeCycleState : ReplicationManagerReport.HealthState.values()) {
            this.report.setStat(lifeCycleState.toString(), (long)((Random)rand).nextInt(Integer.MAX_VALUE));
            ArrayList<ContainerID> containers = new ArrayList<ContainerID>();
            for (int i = 0; i < 10; ++i) {
                containers.add(ContainerID.valueOf((long)((Random)rand).nextInt(Integer.MAX_VALUE)));
            }
            this.report.setSample(lifeCycleState.toString(), containers);
        }
        HddsProtos.ReplicationManagerReportProto proto = this.report.toProtobuf();
        ReplicationManagerReport newReport = ReplicationManagerReport.fromProtobuf((HddsProtos.ReplicationManagerReportProto)proto);
        Assertions.assertEquals((long)this.report.getReportTimeStamp(), (long)newReport.getReportTimeStamp());
        for (HddsProtos.LifeCycleState lifeCycleState : HddsProtos.LifeCycleState.values()) {
            Assertions.assertEquals((long)this.report.getStat(lifeCycleState), (long)newReport.getStat(lifeCycleState));
        }
        for (HddsProtos.LifeCycleState lifeCycleState : ReplicationManagerReport.HealthState.values()) {
            Assertions.assertEquals((Object)this.report.getSample((ReplicationManagerReport.HealthState)lifeCycleState), (Object)newReport.getSample((ReplicationManagerReport.HealthState)lifeCycleState));
        }
    }

    @Test
    public void testDeSerializeCanHandleUnknownMetric() {
        HddsProtos.ReplicationManagerReportProto.Builder proto = HddsProtos.ReplicationManagerReportProto.newBuilder();
        proto.setTimestamp(12345L);
        proto.addStat(HddsProtos.KeyIntValue.newBuilder().setKey("unknownValue").setValue(15L).build());
        proto.addStat(HddsProtos.KeyIntValue.newBuilder().setKey(ReplicationManagerReport.HealthState.UNDER_REPLICATED.toString()).setValue(20L).build());
        HddsProtos.KeyContainerIDList.Builder sample = HddsProtos.KeyContainerIDList.newBuilder();
        sample.setKey("unknownValue");
        sample.addContainer(ContainerID.valueOf((long)1L).getProtobuf());
        proto.addStatSample(sample.build());
        ReplicationManagerReport newReport = ReplicationManagerReport.fromProtobuf((HddsProtos.ReplicationManagerReportProto)proto.build());
        Assertions.assertEquals((long)20L, (long)newReport.getStat(ReplicationManagerReport.HealthState.UNDER_REPLICATED));
    }

    @Test
    public void testStatCannotBeSetTwice() {
        this.report.setStat(HddsProtos.LifeCycleState.CLOSED.toString(), 10L);
        Assertions.assertThrows(IllegalStateException.class, () -> this.report.setStat(HddsProtos.LifeCycleState.CLOSED.toString(), 10L));
    }

    @Test
    public void testSampleCannotBeSetTwice() {
        ArrayList<ContainerID> containers = new ArrayList<ContainerID>();
        containers.add(ContainerID.valueOf((long)1L));
        this.report.setSample(HddsProtos.LifeCycleState.CLOSED.toString(), containers);
        Assertions.assertThrows(IllegalStateException.class, () -> this.report.setSample(HddsProtos.LifeCycleState.CLOSED.toString(), containers));
    }
}

