/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSCMNodeInfo {
    private OzoneConfiguration conf = new OzoneConfiguration();
    private String scmServiceId = "scmserviceId";
    private String[] nodes = new String[]{"scm1", "scm2", "scm3"};

    @BeforeEach
    public void setup() {
        this.conf.set("ozone.scm.service.ids", this.scmServiceId);
        this.conf.set("ozone.scm.nodes." + this.scmServiceId, "scm1,scm2,scm3");
    }

    @Test
    public void testScmHANodeInfo() {
        int port = 9880;
        for (String nodeId : this.nodes) {
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost");
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost:" + ++port);
            this.conf.setInt(ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.port", (String[])new String[]{this.scmServiceId, nodeId}), port);
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.security.service.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost:" + ++port);
            this.conf.setInt(ConfUtils.addKeySuffixes((String)"ozone.scm.security.service.port", (String[])new String[]{this.scmServiceId, nodeId}), port);
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost:" + ++port);
            this.conf.setInt(ConfUtils.addKeySuffixes((String)"ozone.scm.client.port", (String[])new String[]{this.scmServiceId, nodeId}), port);
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost:" + ++port);
            this.conf.setInt(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{this.scmServiceId, nodeId}), port);
        }
        List scmNodeInfos = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        port = 9880;
        int count = 1;
        for (SCMNodeInfo scmNodeInfo : scmNodeInfos) {
            Assertions.assertEquals((Object)this.scmServiceId, (Object)scmNodeInfo.getServiceId());
            Assertions.assertEquals((Object)("scm" + count++), (Object)scmNodeInfo.getNodeId());
            Assertions.assertEquals((Object)("localhost:" + ++port), (Object)scmNodeInfo.getBlockClientAddress());
            Assertions.assertEquals((Object)("localhost:" + ++port), (Object)scmNodeInfo.getScmSecurityAddress());
            Assertions.assertEquals((Object)("localhost:" + ++port), (Object)scmNodeInfo.getScmClientAddress());
            Assertions.assertEquals((Object)("localhost:" + ++port), (Object)scmNodeInfo.getScmDatanodeAddress());
        }
    }

    @Test
    public void testSCMHANodeInfoWithDefaultPorts() {
        for (String nodeId : this.nodes) {
            this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{this.scmServiceId, nodeId}), "localhost");
        }
        List scmNodeInfos = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        int count = 1;
        for (SCMNodeInfo scmNodeInfo : scmNodeInfos) {
            Assertions.assertEquals((Object)this.scmServiceId, (Object)scmNodeInfo.getServiceId());
            Assertions.assertEquals((Object)("scm" + count++), (Object)scmNodeInfo.getNodeId());
            Assertions.assertEquals((Object)"localhost:9863", (Object)scmNodeInfo.getBlockClientAddress());
            Assertions.assertEquals((Object)"localhost:9961", (Object)scmNodeInfo.getScmSecurityAddress());
            Assertions.assertEquals((Object)"localhost:9860", (Object)scmNodeInfo.getScmClientAddress());
            Assertions.assertEquals((Object)"localhost:9861", (Object)scmNodeInfo.getScmDatanodeAddress());
        }
    }

    @Test
    public void testSCMHANodeInfoWithMissingSCMAddress() {
        this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{this.scmServiceId, "scm1"}), "localhost");
        this.conf.set(ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{this.scmServiceId, "scm1"}), "localhost");
        Assertions.assertThrows(ConfigurationException.class, () -> SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf));
    }

    @Test
    public void testNonHAWithRestDefaults() {
        OzoneConfiguration config = new OzoneConfiguration();
        config.set("ozone.scm.client.address", "localhost");
        List scmNodeInfos = SCMNodeInfo.buildNodeInfo((ConfigurationSource)config);
        Assertions.assertNotNull((Object)scmNodeInfos);
        Assertions.assertEquals((int)1, (int)scmNodeInfos.size());
        Assertions.assertEquals((Object)"localhost:9863", (Object)((SCMNodeInfo)scmNodeInfos.get(0)).getBlockClientAddress());
        Assertions.assertEquals((Object)"localhost:9961", (Object)((SCMNodeInfo)scmNodeInfos.get(0)).getScmSecurityAddress());
        Assertions.assertEquals((Object)"localhost:9860", (Object)((SCMNodeInfo)scmNodeInfos.get(0)).getScmClientAddress());
        Assertions.assertEquals((Object)"localhost:9861", (Object)((SCMNodeInfo)scmNodeInfos.get(0)).getScmDatanodeAddress());
    }
}

