/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.InnerNodeImpl;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public class TestNetworkTopologyImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestNetworkTopologyImpl.class);
    private NetworkTopology cluster;
    private Node[] dataNodes;
    private Random random = new Random();
    private Consumer<List<? extends Node>> mockedShuffleOperation;

    @BeforeEach
    void beforeAll() {
        this.mockedShuffleOperation = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doAnswer(args -> {
            List collection = (List)args.getArgument(0);
            Collections.shuffle(collection);
            return null;
        }).when(this.mockedShuffleOperation)).accept(ArgumentMatchers.any());
    }

    public void initNetworkTopology(NodeSchema[] schemas, Node[] nodeArray) {
        NodeSchemaManager.getInstance().init(schemas, true);
        this.cluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance(), this.mockedShuffleOperation);
        this.dataNodes = (Node[])nodeArray.clone();
        for (int i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.add(this.dataNodes[i]);
        }
    }

    public static Stream<Arguments> topologies() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/")}}), Arguments.arguments((Object[])new Object[]{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/r2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/r2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/r2"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/r3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/r3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/r3")}}), Arguments.arguments((Object[])new Object[]{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/r1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d2/r3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d2/r3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r3")}}), Arguments.arguments((Object[])new Object[]{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.NODEGROUP_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/r2/ng3"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("9.9.9.9", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("10.10.10.10", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("11.11.11.11", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("12.12.12.12", "/d3/r2/ng2"), TestNetworkTopologyImpl.createDatanode("13.13.13.13", "/d3/r2/ng2"), TestNetworkTopologyImpl.createDatanode("14.14.14.14", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("15.15.15.15", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("16.16.16.16", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("17.17.17.17", "/d4/r1/ng2"), TestNetworkTopologyImpl.createDatanode("18.18.18.18", "/d4/r1/ng2"), TestNetworkTopologyImpl.createDatanode("19.19.19.19", "/d4/r1/ng3"), TestNetworkTopologyImpl.createDatanode("20.20.20.20", "/d4/r1/ng3")}}), Arguments.arguments((Object[])new Object[]{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.REGION_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.NODEGROUP_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("9.9.9.9", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("10.10.10.10", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("11.11.11.11", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("12.12.12.12", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("13.13.13.13", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("14.14.14.14", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("15.15.15.15", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("16.16.16.16", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("17.17.17.17", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("18.18.18.18", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("19.19.19.19", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("20.20.20.20", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("21.21.21.21", "/d2/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("22.22.22.22", "/d2/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("23.23.23.23", "/d2/rg2/r2/ng1"), TestNetworkTopologyImpl.createDatanode("24.24.24.24", "/d2/rg2/r2/ng1"), TestNetworkTopologyImpl.createDatanode("25.25.25.25", "/d2/rg2/r2/ng1")}}));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testContains(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        Node nodeNotInMap = TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r4");
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assertions.assertTrue((boolean)this.cluster.contains(this.dataNodes[i]));
        }
        Assertions.assertFalse((boolean)this.cluster.contains(nodeNotInMap));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testNumOfChildren(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        Assertions.assertEquals((int)this.dataNodes.length, (int)this.cluster.getNumOfLeafNode(null));
        Assertions.assertEquals((int)0, (int)this.cluster.getNumOfLeafNode("/switch1/node1"));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testGetNode(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        Assertions.assertEquals((Object)this.cluster.getNode(""), (Object)this.cluster.getNode(null));
        Assertions.assertEquals((Object)this.cluster.getNode(""), (Object)this.cluster.getNode("/"));
        Assertions.assertNull((Object)this.cluster.getNode("/switch1/node1"));
        Assertions.assertNull((Object)this.cluster.getNode("/switch1"));
        if (this.cluster.getNode("/d1") != null) {
            ArrayList<String> excludedScope = new ArrayList<String>();
            excludedScope.add("/d");
            Node n = this.cluster.getNode(0, "/d1", excludedScope, null, null, 0);
            Assertions.assertNotNull((Object)n);
        }
    }

    @Test
    public void testCreateInvalidTopology() {
        NodeSchema[] schemas = new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA};
        NodeSchemaManager.getInstance().init(schemas, true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance(), this.mockedShuffleOperation);
        Node[] invalidDataNodes = new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r2"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2")};
        newCluster.add(invalidDataNodes[0]);
        newCluster.add(invalidDataNodes[1]);
        try {
            newCluster.add(invalidDataNodes[2]);
            Assertions.fail((String)"expected InvalidTopologyException");
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Failed to add"));
            Assertions.assertTrue((boolean)e.getMessage().contains("Its path depth is not " + newCluster.getMaxLevel()));
        }
    }

    @Test
    public void testInitWithConfigFile() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        OzoneConfiguration conf = new OzoneConfiguration();
        try {
            String filePath = classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath();
            conf.set("ozone.scm.network.topology.schema.file", filePath);
            NetworkTopologyImpl newCluster = new NetworkTopologyImpl((ConfigurationSource)conf);
            LOG.info("network topology max level = {}", (Object)newCluster.getMaxLevel());
        }
        catch (Throwable e) {
            Assertions.fail((String)"should succeed");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testAncestor(NodeSchema[] schemas, Node[] nodeArray) {
        int maxLevel;
        this.initNetworkTopology(schemas, nodeArray);
        Assumptions.assumeTrue((this.cluster.getMaxLevel() > 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.cluster.isSameParent(this.dataNodes[0], this.dataNodes[1]));
        for (maxLevel = this.cluster.getMaxLevel(); maxLevel > 1; --maxLevel) {
            Assertions.assertTrue((boolean)this.cluster.isSameAncestor(this.dataNodes[0], this.dataNodes[1], maxLevel - 1));
        }
        Assertions.assertFalse((boolean)this.cluster.isSameParent(this.dataNodes[1], this.dataNodes[2]));
        Assertions.assertFalse((boolean)this.cluster.isSameParent(null, this.dataNodes[2]));
        Assertions.assertFalse((boolean)this.cluster.isSameParent(this.dataNodes[1], null));
        Assertions.assertFalse((boolean)this.cluster.isSameParent(null, null));
        Assertions.assertFalse((boolean)this.cluster.isSameAncestor(this.dataNodes[1], this.dataNodes[2], 0));
        Assertions.assertFalse((boolean)this.cluster.isSameAncestor(this.dataNodes[1], null, 1));
        Assertions.assertFalse((boolean)this.cluster.isSameAncestor(null, this.dataNodes[2], 1));
        Assertions.assertFalse((boolean)this.cluster.isSameAncestor(null, null, 1));
        maxLevel = this.cluster.getMaxLevel();
        Assertions.assertTrue((boolean)this.cluster.isSameAncestor(this.dataNodes[this.random.nextInt(this.cluster.getNumOfLeafNode(null))], this.dataNodes[this.random.nextInt(this.cluster.getNumOfLeafNode(null))], maxLevel - 1));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testAddRemove(NodeSchema[] schemas, Node[] nodeArray) {
        int i;
        this.initNetworkTopology(schemas, nodeArray);
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.remove(this.dataNodes[i]);
        }
        for (i = 0; i < this.dataNodes.length; ++i) {
            Assertions.assertFalse((boolean)this.cluster.contains(this.dataNodes[i]));
        }
        Assertions.assertEquals((int)0, (int)this.cluster.getNumOfLeafNode(null));
        Assertions.assertEquals((int)0, (int)this.cluster.getNumOfNodes(2));
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.add(this.dataNodes[i]);
        }
        Assertions.assertTrue((this.cluster.getNumOfNodes(2) > 0 ? 1 : 0) != 0);
        try {
            this.cluster.add((Node)this.cluster.chooseRandom(null).getParent());
            Assertions.fail((String)"Inner node can not be added manually");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Not allowed to add an inner node"));
        }
        try {
            this.cluster.remove((Node)this.cluster.chooseRandom(null).getParent());
            Assertions.fail((String)"Inner node can not be removed manually");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Not allowed to remove an inner node"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testGetNumOfNodesWithLevel(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        int maxLevel = this.cluster.getMaxLevel();
        try {
            Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(0));
            Assertions.fail((String)"level 0 is not supported");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(0));
            Assertions.fail((String)"level 0 is not supported");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(maxLevel + 1));
            Assertions.fail((String)"level out of scope");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(maxLevel + 1));
            Assertions.fail((String)"level out of scope");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(1));
        Assertions.assertEquals((int)1, (int)this.cluster.getNumOfNodes(1));
        Assertions.assertEquals((int)this.dataNodes.length, (int)this.cluster.getNumOfNodes(maxLevel));
        Assertions.assertEquals((int)this.dataNodes.length, (int)this.cluster.getNumOfNodes(maxLevel));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testGetNodesWithLevel(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        int maxLevel = this.cluster.getMaxLevel();
        try {
            Assertions.assertNotNull((Object)this.cluster.getNodes(0));
            Assertions.fail((String)"level 0 is not supported");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assertions.assertNotNull((Object)this.cluster.getNodes(maxLevel + 1));
            Assertions.fail((String)"level out of scope");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        Assertions.assertEquals((int)1, (int)this.cluster.getNodes(1).size());
        Assertions.assertEquals((int)this.dataNodes.length, (int)this.cluster.getNodes(maxLevel).size());
        Assertions.assertEquals((int)this.dataNodes.length, (int)this.cluster.getNodes(maxLevel).size());
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testChooseRandomSimple(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        String path = this.dataNodes[this.random.nextInt(this.dataNodes.length)].getNetworkFullPath();
        Assertions.assertEquals((Object)path, (Object)this.cluster.chooseRandom(path).getNetworkFullPath());
        path = path.substring(0, path.lastIndexOf("/"));
        while (!path.equals("")) {
            Assertions.assertTrue((boolean)this.cluster.chooseRandom(path).getNetworkLocation().startsWith(path));
            Node node = this.cluster.chooseRandom("~" + path);
            Assertions.assertFalse((boolean)node.getNetworkLocation().startsWith(path));
            path = path.substring(0, path.lastIndexOf("/"));
        }
        Assertions.assertNotNull((Object)this.cluster.chooseRandom(null));
        Assertions.assertNotNull((Object)this.cluster.chooseRandom(""));
        Assertions.assertNotNull((Object)this.cluster.chooseRandom("/"));
        Assertions.assertNull((Object)this.cluster.chooseRandom("~"));
        Assertions.assertNull((Object)this.cluster.chooseRandom("~/"));
        path = this.dataNodes[this.random.nextInt(this.dataNodes.length)].getNetworkFullPath();
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(path);
        Assertions.assertNull((Object)this.cluster.chooseRandom(path, pathList));
        Assertions.assertNotNull((Object)this.cluster.chooseRandom(null, pathList));
        Assertions.assertNotNull((Object)this.cluster.chooseRandom("", pathList));
        Assertions.assertNull((Object)this.cluster.chooseRandom("", Arrays.asList(this.dataNodes)));
        Assertions.assertNull((Object)this.cluster.chooseRandom("/", Arrays.asList(this.dataNodes)));
        Assertions.assertNull((Object)this.cluster.chooseRandom("~", Arrays.asList(this.dataNodes)));
        Assertions.assertNull((Object)this.cluster.chooseRandom("~/", Arrays.asList(this.dataNodes)));
        Assertions.assertNull((Object)this.cluster.chooseRandom(null, Arrays.asList(this.dataNodes)));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testChooseRandomExcludedScope(NodeSchema[] schemas, Node[] nodeArray) {
        Map<Node, Integer> frequency;
        String scope;
        int[] excludedNodeIndexs;
        this.initNetworkTopology(schemas, nodeArray);
        for (int i : excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)}) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                frequency = this.pickNodesAtRandom(100, scope, null, 0);
                for (Node key : this.dataNodes) {
                    if (!key.isDescendant(path)) continue;
                    Assertions.assertEquals((int)0, (int)frequency.get(key));
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        frequency = this.pickNodes(100, null, null, null, 0);
        for (Node key : this.dataNodes) {
            Assertions.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        frequency = this.pickNodes(100, arrayList, null, null, 0);
        for (Node key : this.dataNodes) {
            Assertions.assertEquals((int)0, (Integer)frequency.get(key));
        }
        scope = "~";
        frequency = this.pickNodesAtRandom(100, scope, null, 0);
        for (Node key : this.dataNodes) {
            Assertions.assertEquals((int)0, (Integer)frequency.get(key));
        }
        arrayList.clear();
        arrayList.add("/city1");
        frequency = this.pickNodes(this.cluster.getNumOfLeafNode(null), arrayList, null, null, 0);
        for (Node key : this.dataNodes) {
            Assertions.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testChooseRandomExcludedNode(NodeSchema[] schemas, Node[] nodeArray) {
        int ancestorGen;
        Map<Node, Integer> frequency;
        this.initNetworkTopology(schemas, nodeArray);
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        for (Node[] list : excludedNodeLists) {
            List<Node> excludedList = Arrays.asList(list);
            for (int ancestorGen2 = 0; ancestorGen2 < this.cluster.getMaxLevel(); ++ancestorGen2) {
                frequency = this.pickNodesAtRandom(leafNum, null, excludedList, ancestorGen2);
                List ancestorList = NetUtils.getAncestorList((NetworkTopology)this.cluster, excludedList, (int)ancestorGen2);
                for (Node key : this.dataNodes) {
                    if (!excludedList.contains(key) && (ancestorList.size() <= 0 || !ancestorList.stream().map(a -> (InnerNode)a).anyMatch(a -> a.isAncestor(key)))) continue;
                    Assertions.assertEquals((int)0, (Integer)frequency.get(key));
                }
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodesAtRandom(leafNum, null, excludedList, ancestorGen);
            for (Node key : this.dataNodes) {
                Assertions.assertEquals((int)0, (Integer)frequency.get(key));
            }
        }
        excludedList = Arrays.asList(TestNetworkTopologyImpl.createDatanode("1.1.1.1.", "/city1/rack1"));
        for (ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodes(leafNum, null, excludedList, null, ancestorGen);
            for (Node key : this.dataNodes) {
                Assertions.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testChooseRandomExcludedNodeAndScope(NodeSchema[] schemas, Node[] nodeArray) {
        Map<Node, Integer> frequency;
        String scope;
        this.initNetworkTopology(schemas, nodeArray);
        int[] excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        for (int i : excludedNodeIndexs) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                    for (Node[] list : excludedNodeLists) {
                        List<Node> excludedList = Arrays.asList(list);
                        frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, ancestorGen);
                        List ancestorList = NetUtils.getAncestorList((NetworkTopology)this.cluster, excludedList, (int)ancestorGen);
                        for (Node key : this.dataNodes) {
                            if (!excludedList.contains(key) && !key.isDescendant(path) && (ancestorList.size() <= 0 || !ancestorList.stream().map(a -> (InnerNode)a).anyMatch(a -> a.isAncestor(key)))) continue;
                            Assertions.assertEquals((int)0, (Integer)frequency.get(key));
                        }
                    }
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (int i : excludedNodeIndexs) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                    frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, ancestorGen);
                    for (Node key : this.dataNodes) {
                        Assertions.assertEquals((int)0, (Integer)frequency.get(key));
                    }
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodes(leafNum, null, null, null, ancestorGen);
            for (Node key : this.dataNodes) {
                Assertions.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testChooseRandomWithAffinityNode(NodeSchema[] schemas, Node[] nodeArray) {
        Map<Node, Integer> frequency;
        this.initNetworkTopology(schemas, nodeArray);
        int[] excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int[] affinityNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedScopeIndexs = new Node[][]{{this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        ArrayList<String> pathList = new ArrayList();
        for (int k : affinityNodeIndexs) {
            Node[][] nodeArrayArray = excludedScopeIndexs;
            int n = nodeArrayArray.length;
            for (int i = 0; i < n; ++i) {
                Node[] excludedScopes = nodeArrayArray[i];
                pathList.clear();
                pathList.addAll(Arrays.stream(excludedScopes).map(node -> node.getNetworkFullPath()).collect(Collectors.toList()));
                while (!((String)pathList.get(0)).equals("")) {
                    for (int ancestorGen = this.cluster.getMaxLevel() - 1; ancestorGen > 0; --ancestorGen) {
                        Node affinityNode = this.dataNodes[k];
                        for (Node[] list : excludedNodeLists) {
                            List<Node> excludedList = Arrays.asList(list);
                            frequency = this.pickNodes(leafNum, pathList, excludedList, affinityNode, ancestorGen);
                            Node affinityAncestor = affinityNode.getAncestor(ancestorGen);
                            for (Node key : this.dataNodes) {
                                if (affinityAncestor == null) continue;
                                if (frequency.get(key) > 0) {
                                    Assertions.assertTrue((boolean)affinityAncestor.isAncestor(key));
                                    continue;
                                }
                                if (!affinityAncestor.isAncestor(key) || excludedList != null && excludedList.contains(key)) continue;
                                if (pathList != null) {
                                    if (pathList.stream().anyMatch(arg_0 -> ((Node)key).isDescendant(arg_0))) continue;
                                }
                                if (key.getNetworkFullPath().equals(affinityNode.getNetworkFullPath())) continue;
                                Assertions.fail((String)("Node is not picked when sequentially going through ancestor node's leaf nodes. node:" + key.getNetworkFullPath() + ", ancestor node:" + affinityAncestor.getNetworkFullPath() + ", excludedScope: " + pathList + ", excludedList:" + excludedList));
                            }
                        }
                    }
                    pathList = pathList.stream().map(path -> path.substring(0, path.lastIndexOf("/"))).collect(Collectors.toList());
                }
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (int k : affinityNodeIndexs) {
            for (int i : excludedNodeIndexs) {
                String path2 = this.dataNodes[i].getNetworkFullPath();
                while (!path2.equals("")) {
                    String scope = "~" + path2;
                    for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                        frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, this.dataNodes[k], ancestorGen);
                        for (Node key : this.dataNodes) {
                            Assertions.assertEquals((int)0, (Integer)frequency.get(key));
                        }
                    }
                    path2 = path2.substring(0, path2.lastIndexOf("/"));
                }
            }
        }
        int ancestorGen = this.cluster.getMaxLevel() - 1;
        for (int k : affinityNodeIndexs) {
            while (ancestorGen > 0) {
                frequency = this.pickNodes(leafNum, null, null, this.dataNodes[k], ancestorGen);
                Node affinityAncestor = this.dataNodes[k].getAncestor(ancestorGen);
                for (Node key : this.dataNodes) {
                    if (frequency.get(key) <= 0 || affinityAncestor == null) continue;
                    Assertions.assertTrue((boolean)affinityAncestor.isAncestor(key));
                }
                --ancestorGen;
            }
        }
        try {
            this.cluster.chooseRandom(null, null, null, this.dataNodes[0], this.cluster.getMaxLevel());
            Assertions.fail((String)"ancestor generation exceeds max level, should fail");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("ancestorGen " + this.cluster.getMaxLevel() + " exceeds this network topology acceptable level"));
        }
    }

    @Test
    public void testCost() {
        Node[] nodeList;
        ArrayList<NodeSchema> schemas = new ArrayList<NodeSchema>();
        schemas.add(NetConstants.ROOT_SCHEMA);
        schemas.add(NetConstants.RACK_SCHEMA);
        schemas.add(NetConstants.NODEGROUP_SCHEMA);
        schemas.add(NetConstants.LEAF_SCHEMA);
        NodeSchemaManager manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(manager, this.mockedShuffleOperation);
        for (Node node : nodeList = new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/r1/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/r2/ng1")}) {
            newCluster.add(node);
        }
        Node outScopeNode1 = TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/r2/ng2");
        Node outScopeNode2 = TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/r2/ng2");
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(nodeList[0], null));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(null, nodeList[0]));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(outScopeNode1, nodeList[0]));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(nodeList[0], outScopeNode1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(outScopeNode1, outScopeNode2));
        Assertions.assertEquals((int)0, (int)newCluster.getDistanceCost(null, null));
        Assertions.assertEquals((int)0, (int)newCluster.getDistanceCost(nodeList[0], nodeList[0]));
        Assertions.assertEquals((int)2, (int)newCluster.getDistanceCost(nodeList[0], nodeList[1]));
        Assertions.assertEquals((int)4, (int)newCluster.getDistanceCost(nodeList[0], nodeList[2]));
        Assertions.assertEquals((int)6, (int)newCluster.getDistanceCost(nodeList[0], nodeList[3]));
        schemas.clear();
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.ROOT).setCost(5).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.INNER_NODE).setCost(3).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.INNER_NODE).setCost(1).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.LEAF_NODE).build());
        manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        newCluster = new NetworkTopologyImpl(manager, this.mockedShuffleOperation);
        for (Node node : nodeList) {
            newCluster.add(node);
        }
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(nodeList[0], null));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(null, nodeList[0]));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(outScopeNode1, nodeList[0]));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(nodeList[0], outScopeNode1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)newCluster.getDistanceCost(outScopeNode1, outScopeNode2));
        Assertions.assertEquals((int)0, (int)newCluster.getDistanceCost(null, null));
        Assertions.assertEquals((int)0, (int)newCluster.getDistanceCost(nodeList[0], nodeList[0]));
        Assertions.assertEquals((int)2, (int)newCluster.getDistanceCost(nodeList[0], nodeList[1]));
        Assertions.assertEquals((int)8, (int)newCluster.getDistanceCost(nodeList[0], nodeList[2]));
        Assertions.assertEquals((int)18, (int)newCluster.getDistanceCost(nodeList[0], nodeList[3]));
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testSortByDistanceCost(NodeSchema[] schemas, Node[] nodeArray) {
        Node[] readers;
        this.initNetworkTopology(schemas, nodeArray);
        Node[][] nodes = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        for (Node reader : readers = new Node[]{null, this.dataNodes[0], this.dataNodes[this.dataNodes.length - 1], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}) {
            for (Node[] nodeList : nodes) {
                for (int length = nodeList.length; length > 0; --length) {
                    List ret = this.cluster.sortByDistanceCost(reader, Arrays.asList(nodeList), length);
                    Assertions.assertEquals((int)length, (int)ret.size());
                    for (int i = 0; i < ret.size(); ++i) {
                        if (i + 1 >= ret.size()) continue;
                        int cost1 = this.cluster.getDistanceCost(reader, (Node)ret.get(i));
                        int cost2 = this.cluster.getDistanceCost(reader, (Node)ret.get(i + 1));
                        Assertions.assertTrue((cost1 == Integer.MAX_VALUE || cost1 <= cost2 ? 1 : 0) != 0, (String)("reader:" + (reader != null ? reader.getNetworkFullPath() : "null") + ",node1:" + ((Node)ret.get(i)).getNetworkFullPath() + ",node2:" + ((Node)ret.get(i + 1)).getNetworkFullPath() + ",cost1:" + cost1 + ",cost2:" + cost2));
                    }
                }
            }
        }
        List<Object> nodeList = Arrays.asList((Object[])this.dataNodes.clone());
        for (Node reader : readers) {
            for (int length = nodeList.size(); length >= 0; --length) {
                List sortedNodeList = this.cluster.sortByDistanceCost(reader, nodeList, length);
                Assertions.assertEquals((int)length, (int)sortedNodeList.size());
                for (int i = 0; i < sortedNodeList.size(); ++i) {
                    if (i + 1 >= sortedNodeList.size()) continue;
                    int cost1 = this.cluster.getDistanceCost(reader, (Node)sortedNodeList.get(i));
                    int cost2 = this.cluster.getDistanceCost(reader, (Node)sortedNodeList.get(i + 1));
                    Assertions.assertTrue((cost1 == Integer.MAX_VALUE || cost1 <= cost2 ? 1 : 0) != 0, (String)("reader:" + (reader != null ? reader.getNetworkFullPath() : "null") + ",node1:" + ((Node)sortedNodeList.get(i)).getNetworkFullPath() + ",node2:" + ((Node)sortedNodeList.get(i + 1)).getNetworkFullPath() + ",cost1:" + cost1 + ",cost2:" + cost2));
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topologies"})
    public void testSortByDistanceCostNullReader(NodeSchema[] schemas, Node[] nodeArray) {
        this.initNetworkTopology(schemas, nodeArray);
        List<Object> nodeList = Arrays.asList((Object[])this.dataNodes.clone());
        Node reader = null;
        NetworkTopology spyCluster = (NetworkTopology)Mockito.spy((Object)this.cluster);
        for (int length = nodeList.size(); length > 0; --length) {
            List ret = spyCluster.sortByDistanceCost(reader, nodeList, length);
            ((Consumer)Mockito.verify(this.mockedShuffleOperation)).accept(ArgumentMatchers.any());
            ((NetworkTopology)Mockito.verify((Object)spyCluster, (VerificationMode)Mockito.never())).getDistanceCost((Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any());
            Assertions.assertEquals((int)length, (int)ret.size());
            Assertions.assertTrue((boolean)nodeList.containsAll(ret));
            Mockito.reset((Object[])new Consumer[]{this.mockedShuffleOperation});
        }
    }

    @Test
    public void testSingleNodeRackWithAffinityNode() {
        ArrayList<NodeSchema> schemas = new ArrayList<NodeSchema>();
        schemas.add(NetConstants.ROOT_SCHEMA);
        schemas.add(NetConstants.RACK_SCHEMA);
        schemas.add(NetConstants.LEAF_SCHEMA);
        NodeSchemaManager manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(manager, this.mockedShuffleOperation);
        Node node = TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1");
        newCluster.add(node);
        Node chosenNode = newCluster.chooseRandom("", null, null, node, 0);
        Assertions.assertNull((Object)chosenNode);
        chosenNode = newCluster.chooseRandom("", null, Arrays.asList(node), node, 0);
        Assertions.assertNull((Object)chosenNode);
        chosenNode = newCluster.chooseRandom("", Arrays.asList(node.getNetworkFullPath()), Arrays.asList(node), node, 0);
        Assertions.assertNull((Object)chosenNode);
    }

    @Test
    public void testUpdateNode() {
        ArrayList<NodeSchema> schemas = new ArrayList<NodeSchema>();
        schemas.add(NetConstants.ROOT_SCHEMA);
        schemas.add(NetConstants.DATACENTER_SCHEMA);
        schemas.add(NetConstants.RACK_SCHEMA);
        schemas.add(NetConstants.LEAF_SCHEMA);
        NodeSchemaManager manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(manager, this.mockedShuffleOperation);
        Node node = TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/r1");
        newCluster.add(node);
        Assertions.assertTrue((boolean)newCluster.contains(node));
        Node newNode = TestNetworkTopologyImpl.createDatanode("1.1.1.2", "/d1/r1");
        Assertions.assertFalse((boolean)newCluster.contains(newNode));
        newCluster.update(node, newNode);
        Assertions.assertFalse((boolean)newCluster.contains(node));
        Assertions.assertTrue((boolean)newCluster.contains(newNode));
        Node nodeExisting = TestNetworkTopologyImpl.createDatanode("1.1.1.3", "/d1/r1");
        Node newNode2 = TestNetworkTopologyImpl.createDatanode("1.1.1.4", "/d1/r1");
        Assertions.assertFalse((boolean)newCluster.contains(nodeExisting));
        Assertions.assertFalse((boolean)newCluster.contains(newNode2));
        newCluster.update(nodeExisting, newNode2);
        Assertions.assertFalse((boolean)newCluster.contains(nodeExisting));
        Assertions.assertTrue((boolean)newCluster.contains(newNode2));
        Node newNode3 = TestNetworkTopologyImpl.createDatanode("1.1.1.5", "/d1/r1");
        Assertions.assertFalse((boolean)newCluster.contains(newNode3));
        newCluster.update(null, newNode3);
        Assertions.assertTrue((boolean)newCluster.contains(newNode3));
    }

    public void testIsAncestor() {
        NodeImpl r1 = new NodeImpl("r1", "/", 0);
        NodeImpl r12 = new NodeImpl("r12", "/", 0);
        NodeImpl dc = new NodeImpl("dc", "/r12", 0);
        Assertions.assertFalse((boolean)r1.isAncestor((Node)dc));
        Assertions.assertFalse((boolean)r1.isAncestor("/r12/dc2"));
        Assertions.assertFalse((boolean)dc.isDescendant((Node)r1));
        Assertions.assertFalse((boolean)dc.isDescendant("/r1"));
        Assertions.assertTrue((boolean)r12.isAncestor((Node)dc));
        Assertions.assertTrue((boolean)r12.isAncestor("/r12/dc2"));
        Assertions.assertTrue((boolean)dc.isDescendant((Node)r12));
        Assertions.assertTrue((boolean)dc.isDescendant("/r12"));
    }

    @Test
    public void testGetLeafOnLeafParent() {
        InnerNodeImpl root = new InnerNodeImpl("", "", null, 0, 0);
        InnerNodeImpl r12 = new InnerNodeImpl("r12", "/", (InnerNode)root, 1, 0);
        InnerNodeImpl dc = new InnerNodeImpl("dc", "/r12", (InnerNode)r12, 2, 0);
        NodeImpl n1 = new NodeImpl("n1", "/r12/dc", (InnerNode)dc, 2, 0);
        dc.add((Node)n1);
        ArrayList<String> excludedScope = new ArrayList<String>();
        excludedScope.add("/r1");
        Assertions.assertFalse((boolean)n1.isDescendant("/r1"));
        Assertions.assertEquals((Object)n1, (Object)dc.getLeaf(0, excludedScope, null, 0));
    }

    private static Node createDatanode(String name, String path) {
        return new NodeImpl(name, path, 0);
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope, Collection<Node> excludedNodes, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.chooseRandom(excludedScope, excludedNodes, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(excludedScope.substring(1));
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.chooseRandom("", pathList, excludedNodes, affinityNode, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }

    private Map<Node, Integer> pickNodes(int numNodes, List<String> excludedScopes, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        excludedNodes = excludedNodes == null ? null : (Collection)excludedNodes.stream().distinct().collect(Collectors.toList());
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.getNode(j, null, excludedScopes, excludedNodes, affinityNode, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }
}

