/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.scm.net.NodeSchemaLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Timeout(value=2L)
public class TestNodeSchemaLoader {
    private static final String VALID_SCHEMA_FILE = "good.xml";

    public static Stream<Arguments> getSchemaFiles() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"enforce-error.xml", "layer without prefix defined"}), Arguments.arguments((Object[])new Object[]{"invalid-cost.xml", "Cost should be positive number or 0"}), Arguments.arguments((Object[])new Object[]{"multiple-leaf.xml", "Multiple LEAF layers are found"}), Arguments.arguments((Object[])new Object[]{"multiple-root.xml", "Multiple ROOT layers are found"}), Arguments.arguments((Object[])new Object[]{"no-leaf.xml", "No LEAF layer is found"}), Arguments.arguments((Object[])new Object[]{"no-root.xml", "No ROOT layer is found"}), Arguments.arguments((Object[])new Object[]{"path-layers-size-mismatch.xml", "Topology path depth doesn't match layer element numbers"}), Arguments.arguments((Object[])new Object[]{"path-with-id-reference-failure.xml", "No layer found for id"}), Arguments.arguments((Object[])new Object[]{"unknown-layer-type.xml", "Unsupported layer type"}), Arguments.arguments((Object[])new Object[]{"wrong-path-order-1.xml", "Topology path doesn't start with ROOT layer"}), Arguments.arguments((Object[])new Object[]{"wrong-path-order-2.xml", "Topology path doesn't end with LEAF layer"}), Arguments.arguments((Object[])new Object[]{"no-topology.xml", "no or multiple <topology> element"}), Arguments.arguments((Object[])new Object[]{"multiple-topology.xml", "no or multiple <topology> element"}), Arguments.arguments((Object[])new Object[]{"invalid-version.xml", "Bad layoutversion value"}), Arguments.arguments((Object[])new Object[]{"external-entity.xml", "accessExternalDTD"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getSchemaFiles"})
    public void testInvalid(String schemaFile, String errMsg) {
        String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(schemaFile);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
        TestNodeSchemaLoader.assertMessageContains(e.getMessage(), errMsg, schemaFile);
    }

    @Test
    public void testGood() throws Exception {
        String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(VALID_SCHEMA_FILE);
        NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath);
    }

    @Test
    public void testNotExist() {
        String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(VALID_SCHEMA_FILE).replace(VALID_SCHEMA_FILE, "non-existent.xml");
        Exception e = (Exception)Assertions.assertThrows(FileNotFoundException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
        TestNodeSchemaLoader.assertMessageContains(e.getMessage(), "not found", "non-existent.xml");
    }

    private static void assertMessageContains(String actual, String expected, String testCase) {
        if (!actual.contains(expected)) {
            Assertions.fail((String)String.format("Expected message for '%s' to contain '%s', but got: '%s'", testCase, expected, actual));
        }
    }

    private static String getClassloaderResourcePath(String file) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("networkTopologyTestFiles/" + file);
        Assertions.assertNotNull((Object)resource);
        return resource.getPath();
    }
}

