/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public class TestNodeSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestNodeSchemaManager.class);
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private NodeSchemaManager manager;
    private OzoneConfiguration conf = new OzoneConfiguration();

    public TestNodeSchemaManager() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath();
        this.conf.set("ozone.scm.network.topology.schema.file", filePath);
        this.manager = NodeSchemaManager.getInstance();
        this.manager.init((ConfigurationSource)this.conf);
    }

    @Test
    public void testFailure1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.manager.getCost(0));
    }

    @Test
    public void testFailure2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.manager.getCost(this.manager.getMaxLevel() + 1));
    }

    @Test
    public void testPass() {
        Assertions.assertEquals((int)4, (int)this.manager.getMaxLevel());
        for (int i = 1; i <= this.manager.getMaxLevel(); ++i) {
            Assertions.assertTrue((this.manager.getCost(i) == 1 || this.manager.getCost(i) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInitFailure() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath() + ".backup";
        this.conf.set("ozone.scm.network.topology.schema.file", filePath);
        Throwable e = Assertions.assertThrows(RuntimeException.class, () -> this.manager.init((ConfigurationSource)this.conf));
        Assertions.assertTrue((boolean)e.getMessage().contains("Failed to load schema file:" + filePath));
    }

    @Test
    public void testComplete() {
        String path = "/node1";
        Assertions.assertEquals((Object)("/default-rack/default-nodegroup" + path), (Object)this.manager.complete(path));
        Assertions.assertEquals((Object)("/rack/default-nodegroup" + path), (Object)this.manager.complete("/rack" + path));
        Assertions.assertEquals((Object)("/default-rack/nodegroup" + path), (Object)this.manager.complete("/nodegroup" + path));
        Assertions.assertNull((Object)this.manager.complete("/dc" + path));
    }
}

