/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.io.FileNotFoundException;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.scm.net.NodeSchemaLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public class TestYamlSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TestYamlSchemaLoader.class);
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static Stream<Arguments> getSchemaFiles() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"multiple-root.yaml", "Multiple root"}), Arguments.arguments((Object[])new Object[]{"middle-leaf.yaml", "Leaf node in the middle"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getSchemaFiles"})
    public void loadSchemaFromFile(String schemaFile, String errMsg) {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/" + schemaFile).getPath();
        Throwable e = Assertions.assertThrows(IllegalArgumentException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
        Assertions.assertTrue((boolean)e.getMessage().contains(errMsg));
    }

    @Test
    public void testGood() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.yaml").getPath();
        Assertions.assertDoesNotThrow(() -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
    }

    @Test
    public void testNotExist() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.yaml").getPath() + ".backup";
        Throwable e = Assertions.assertThrows(FileNotFoundException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
        Assertions.assertTrue((boolean)e.getMessage().contains("not found"));
    }

    @Test
    public void testDefaultYaml() {
        String filePath = this.classLoader.getResource("network-topology-default.yaml").getPath();
        NodeSchemaLoader.NodeSchemaLoadResult result = (NodeSchemaLoader.NodeSchemaLoadResult)Assertions.assertDoesNotThrow(() -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
        Assertions.assertEquals((int)3, (int)result.getSchemaList().size());
    }
}

