/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.keys.HDDSKeyGenerator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class CertificateTestUtils {
    private static final String HASH_ALGO = "SHA256WithRSA";

    private CertificateTestUtils() {
    }

    public static KeyPair aKeyPair(ConfigurationSource conf) throws NoSuchProviderException, NoSuchAlgorithmException {
        return new HDDSKeyGenerator(new SecurityConfig(conf)).generateKey();
    }

    public static X509Certificate createSelfSignedCert(KeyPair keys, String commonName) throws Exception {
        return CertificateTestUtils.createSelfSignedCert(keys, commonName, Duration.ofDays(1L));
    }

    public static X509Certificate createSelfSignedCert(KeyPair keys, String commonName, Duration expiresIn) throws Exception {
        return CertificateTestUtils.createSelfSignedCert(keys, commonName, expiresIn, BigInteger.valueOf(keys.getPublic().hashCode()));
    }

    public static X509Certificate createSelfSignedCert(KeyPair keys, String commonName, Duration expiresIn, BigInteger certId) throws Exception {
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(expiresIn));
        ContentSigner contentSigner = new JcaContentSignerBuilder(HASH_ALGO).build(keys.getPrivate());
        X500Name x500Name = new X500Name("CN=" + commonName);
        SubjectKeyIdentifier keyId = CertificateTestUtils.subjectKeyIdOf(keys);
        AuthorityKeyIdentifier authorityKeyId = CertificateTestUtils.authorityKeyIdOf(keys);
        BasicConstraints constraints = new BasicConstraints(true);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, certId, notBefore, notAfter, x500Name, keys.getPublic());
        certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)keyId).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyId).addExtension(Extension.basicConstraints, true, (ASN1Encodable)constraints);
        return new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
    }

    private static SubjectKeyIdentifier subjectKeyIdOf(KeyPair keys) throws Exception {
        return CertificateTestUtils.extensionUtil().createSubjectKeyIdentifier(CertificateTestUtils.pubKeyInfo(keys));
    }

    private static AuthorityKeyIdentifier authorityKeyIdOf(KeyPair keys) throws Exception {
        return CertificateTestUtils.extensionUtil().createAuthorityKeyIdentifier(CertificateTestUtils.pubKeyInfo(keys));
    }

    private static SubjectPublicKeyInfo pubKeyInfo(KeyPair keys) {
        return SubjectPublicKeyInfo.getInstance((Object)keys.getPublic().getEncoded());
    }

    private static X509ExtensionUtils extensionUtil() throws OperatorCreationException {
        DigestCalculator digest = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        return new X509ExtensionUtils(digest);
    }
}

