/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.exceptions.EmptyTracerStateStringException;
import io.jaegertracing.internal.exceptions.MalformedTracerStateStringException;
import org.apache.hadoop.hdds.tracing.StringCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStringCodec {
    TestStringCodec() {
    }

    @Test
    void testExtract() {
        StringCodec codec = new StringCodec();
        Assertions.assertThrows(EmptyTracerStateStringException.class, () -> codec.extract(null));
        StringBuilder sb = new StringBuilder().append("123");
        MalformedTracerStateStringException malformedException = (MalformedTracerStateStringException)Assertions.assertThrows(MalformedTracerStateStringException.class, () -> codec.extract(sb));
        Assertions.assertEquals((Object)"String does not match tracer state format: 123", (Object)malformedException.getMessage());
        sb.append(":456:789");
        malformedException = (MalformedTracerStateStringException)Assertions.assertThrows(MalformedTracerStateStringException.class, () -> codec.extract(sb));
        Assertions.assertEquals((Object)"String does not match tracer state format: 123:456:789", (Object)malformedException.getMessage());
        sb.append(":66");
        JaegerSpanContext context = codec.extract(sb);
        StringBuilder injected = new StringBuilder();
        codec.inject(context, injected);
        String expectedTraceId = TestStringCodec.pad("123");
        Assertions.assertEquals((Object)expectedTraceId, (Object)context.getTraceId());
        Assertions.assertEquals((Object)(expectedTraceId + ":456:789:66"), (Object)injected.toString());
    }

    private static String pad(String s) {
        return "0000000000000000".substring(s.length()) + s;
    }
}

