/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.InMemoryConfiguration;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.tracing.TestTraceAllMethod;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTracingUtil {
    @Test
    public void testDefaultMethod() {
        TestTraceAllMethod.Service subject = (TestTraceAllMethod.Service)TracingUtil.createProxy((Object)new TestTraceAllMethod.ServiceImpl(), TestTraceAllMethod.Service.class, (ConfigurationSource)TestTracingUtil.tracingEnabled());
        Assertions.assertEquals((Object)"Hello default", (Object)subject.defaultMethod());
    }

    @Test
    public void testInitTracing() {
        Configuration config = Configuration.fromEnv((String)"testInitTracing");
        JaegerTracer tracer = config.getTracerBuilder().build();
        GlobalTracer.registerIfAbsent((Tracer)tracer);
        try (AutoCloseable scope = TracingUtil.createActivatedSpan((String)"initTracing");){
            TracingUtil.exportCurrentSpan();
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not get exception");
        }
    }

    private static MutableConfigurationSource tracingEnabled() {
        InMemoryConfiguration config = new InMemoryConfiguration();
        config.setBoolean("hdds.tracing.enabled", true);
        return config;
    }
}

