/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.HddsIdFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHddsIdFactory {
    private static final Set<Long> ID_SET = ConcurrentHashMap.newKeySet();
    private static final int IDS_PER_THREAD = 10000;
    private static final int NUM_OF_THREADS = 5;

    @AfterEach
    public void cleanup() {
        ID_SET.clear();
    }

    @Test
    public void testGetLongId() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>(5);
        this.addTasks(tasks);
        List<Future<Integer>> result = executor.invokeAll(tasks);
        Assertions.assertEquals((int)50000, (int)ID_SET.size());
        for (Future<Integer> r : result) {
            Assertions.assertEquals((int)10000, (int)r.get());
        }
    }

    private void addTasks(List<Callable<Integer>> tasks) {
        for (int i = 0; i < 5; ++i) {
            Callable<Integer> task = () -> {
                for (int idNum = 0; idNum < 10000; ++idNum) {
                    long var = HddsIdFactory.getLongId();
                    if (ID_SET.contains(var)) {
                        Assertions.fail((String)"Duplicate id found");
                    }
                    ID_SET.add(var);
                }
                return 10000;
            };
            tasks.add(task);
        }
    }
}

