/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.util.ProtobufUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtobufUtils {
    @Test
    public void testUuidToProtobuf() {
        UUID object = UUID.randomUUID();
        HddsProtos.UUID protobuf = ProtobufUtils.toProtobuf((UUID)object);
        Assertions.assertEquals((long)object.getLeastSignificantBits(), (long)protobuf.getLeastSigBits());
        Assertions.assertEquals((long)object.getMostSignificantBits(), (long)protobuf.getMostSigBits());
    }

    @Test
    public void testUuidConversion() {
        UUID original = UUID.randomUUID();
        HddsProtos.UUID protobuf = ProtobufUtils.toProtobuf((UUID)original);
        UUID deserialized = ProtobufUtils.fromProtobuf((HddsProtos.UUID)protobuf);
        Assertions.assertEquals((Object)original, (Object)deserialized);
    }
}

