/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChecksum {
    private static final int BYTES_PER_CHECKSUM = 10;
    private static final ContainerProtos.ChecksumType CHECKSUM_TYPE_DEFAULT = ContainerProtos.ChecksumType.SHA256;

    private Checksum getChecksum(ContainerProtos.ChecksumType type) {
        if (type == null) {
            type = CHECKSUM_TYPE_DEFAULT;
        }
        return new Checksum(type, 10);
    }

    @Test
    public void testVerifyChecksum() throws Exception {
        Checksum checksum = this.getChecksum(null);
        int dataLen = 55;
        byte[] data = RandomStringUtils.randomAlphabetic((int)dataLen).getBytes(StandardCharsets.UTF_8);
        ChecksumData checksumData = checksum.computeChecksum(data);
        Assertions.assertEquals((int)6, (int)checksumData.getChecksums().size());
        Assertions.assertTrue((boolean)Checksum.verifyChecksum((byte[])data, (ChecksumData)checksumData), (String)"Checksum mismatch");
    }

    @Test
    public void testIncorrectChecksum() throws Exception {
        Checksum checksum = this.getChecksum(null);
        byte[] data = RandomStringUtils.randomAlphabetic((int)55).getBytes(StandardCharsets.UTF_8);
        ChecksumData originalChecksumData = checksum.computeChecksum(data);
        data[50] = (byte)(data[50] + 1);
        ChecksumData newChecksumData = checksum.computeChecksum(data);
        Assertions.assertNotEquals((Object)originalChecksumData, (Object)newChecksumData, (String)"Checksums should not match for different data");
    }

    @Test
    public void testChecksumMismatchForDifferentChecksumTypes() {
        Checksum checksum1 = this.getChecksum(null);
        Checksum checksum2 = this.getChecksum(ContainerProtos.ChecksumType.CRC32);
        Assertions.assertNotEquals((Object)checksum1, (Object)checksum2, (String)"Checksums should not match for different checksum types");
    }
}

