/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.ozone.common.ChecksumByteBufferImpl;
import org.apache.hadoop.ozone.common.NativeCheckSumCRC32;
import org.apache.hadoop.ozone.common.PureJavaCrc32ByteBuffer;
import org.apache.hadoop.ozone.common.PureJavaCrc32CByteBuffer;
import org.apache.hadoop.util.NativeCRC32Wrapper;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChecksumImplsComputeSameValues {
    private int dataSize = 0x4000000;
    private ByteBuffer data = ByteBuffer.allocate(this.dataSize);
    private int[] bytesPerChecksum = new int[]{512, 1024, 2048, 4096, 32768, 0x100000};

    @Test
    public void testCRC32ImplsMatch() {
        this.data.clear();
        this.data.put(RandomUtils.nextBytes((int)this.data.remaining()));
        for (int bpc : this.bytesPerChecksum) {
            ArrayList<ChecksumByteBuffer> impls = new ArrayList<ChecksumByteBuffer>();
            impls.add((ChecksumByteBuffer)new PureJavaCrc32ByteBuffer());
            impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl((Checksum)new PureJavaCrc32()));
            impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl((Checksum)new CRC32()));
            if (NativeCRC32Wrapper.isAvailable()) {
                impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl((Checksum)new NativeCheckSumCRC32(1, bpc)));
            }
            Assertions.assertEquals((Object)true, (Object)this.validateImpls(this.data, impls, bpc));
        }
    }

    @Test
    public void testCRC32CImplsMatch() {
        this.data.clear();
        this.data.put(RandomUtils.nextBytes((int)this.data.remaining()));
        for (int bpc : this.bytesPerChecksum) {
            ArrayList<ChecksumByteBuffer> impls = new ArrayList<ChecksumByteBuffer>();
            impls.add((ChecksumByteBuffer)new PureJavaCrc32CByteBuffer());
            impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl((Checksum)new PureJavaCrc32C()));
            try {
                impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl(ChecksumByteBufferFactory.Java9Crc32CFactory.createChecksum()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (NativeCRC32Wrapper.isAvailable()) {
                impls.add((ChecksumByteBuffer)new ChecksumByteBufferImpl((Checksum)new NativeCheckSumCRC32(2, bpc)));
            }
            Assertions.assertEquals((Object)true, (Object)this.validateImpls(this.data, impls, bpc));
        }
    }

    private boolean validateImpls(ByteBuffer buf, List<ChecksumByteBuffer> impls, int bpc) {
        for (int i = 0; i < buf.capacity(); i += bpc) {
            buf.position(i);
            buf.limit(i + bpc);
            impls.get(0).update(buf);
            int res = (int)impls.get(0).getValue();
            impls.get(0).reset();
            for (int j = 1; j < impls.size(); ++j) {
                ChecksumByteBuffer csum = impls.get(j);
                buf.position(i);
                buf.limit(i + bpc);
                csum.update(buf);
                if ((int)csum.getValue() != res) {
                    return false;
                }
                csum.reset();
            }
        }
        return true;
    }
}

