/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import com.google.common.collect.ImmutableList;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChunkBufferImplWithByteBufferList {
    @Test
    public void rejectsNullList() {
        List list = null;
        Assertions.assertThrows(NullPointerException.class, () -> ChunkBuffer.wrap((List)list));
    }

    @Test
    public void acceptsEmptyList() {
        ChunkBuffer subject = ChunkBuffer.wrap((List)ImmutableList.of());
        TestChunkBufferImplWithByteBufferList.assertEmpty(subject);
        TestChunkBufferImplWithByteBufferList.assertEmpty(subject.duplicate(0, 0));
        Assertions.assertThrows(BufferOverflowException.class, () -> subject.put(ByteBuffer.allocate(1)));
    }

    @Test
    public void rejectsMultipleCurrentBuffers() {
        ByteBuffer b1 = TestChunkBufferImplWithByteBufferList.allocate();
        ByteBuffer b2 = TestChunkBufferImplWithByteBufferList.allocate();
        ByteBuffer b3 = TestChunkBufferImplWithByteBufferList.allocate();
        ImmutableList list = ImmutableList.of((Object)b1, (Object)b2, (Object)b3);
        b1.position(b1.limit() - 1);
        b2.position(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestChunkBufferImplWithByteBufferList.lambda$rejectsMultipleCurrentBuffers$2((List)list));
        b1.position(b1.limit() - 1);
        b2.position(0);
        b3.position(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestChunkBufferImplWithByteBufferList.lambda$rejectsMultipleCurrentBuffers$3((List)list));
    }

    private static void assertEmpty(ChunkBuffer subject) {
        Assertions.assertEquals((int)0, (int)subject.position());
        Assertions.assertEquals((int)0, (int)subject.remaining());
        Assertions.assertEquals((int)0, (int)subject.limit());
    }

    private static ByteBuffer allocate() {
        return ByteBuffer.allocate(ThreadLocalRandom.current().nextInt(10, 20));
    }

    private static /* synthetic */ void lambda$rejectsMultipleCurrentBuffers$3(List list) throws Throwable {
        ChunkBuffer.wrap((List)list);
    }

    private static /* synthetic */ void lambda$rejectsMultipleCurrentBuffers$2(List list) throws Throwable {
        ChunkBuffer.wrap((List)list);
    }
}

