/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.HashMap;
import org.apache.hadoop.ozone.lease.Lease;
import org.apache.hadoop.ozone.lease.LeaseAlreadyExistException;
import org.apache.hadoop.ozone.lease.LeaseException;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLeaseManager {
    @Test
    public void testLeaseAcquireAndRelease() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Lease leaseThree = manager.acquire((Object)resourceThree);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assertions.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        Assertions.assertFalse((boolean)leaseTwo.hasExpired());
        Assertions.assertFalse((boolean)leaseThree.hasExpired());
        manager.release((Object)resourceOne);
        manager.release((Object)resourceTwo);
        manager.release((Object)resourceThree);
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Assertions.assertTrue((boolean)leaseTwo.hasExpired());
        Assertions.assertTrue((boolean)leaseThree.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testLeaseAlreadyExist() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assertions.assertThrowsExactly(LeaseAlreadyExistException.class, () -> manager.acquire((Object)resourceOne), (String)("Resource: " + resourceOne));
        manager.release((Object)resourceOne);
        manager.release((Object)resourceTwo);
        manager.shutdown();
    }

    @Test
    public void testLeaseNotFound() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Assertions.assertThrowsExactly(LeaseNotFoundException.class, () -> manager.get((Object)resourceOne), (String)("Resource: " + resourceOne));
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Assertions.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assertions.assertFalse((boolean)leaseTwo.hasExpired());
        manager.release((Object)resourceTwo);
        Assertions.assertTrue((boolean)leaseTwo.hasExpired());
        Assertions.assertThrowsExactly(LeaseNotFoundException.class, () -> manager.get((Object)resourceTwo), (String)("Resource: " + resourceTwo));
        Lease leaseThree = manager.acquire((Object)resourceThree);
        Assertions.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assertions.assertFalse((boolean)leaseThree.hasExpired());
        long sleepTime = leaseThree.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assertions.assertTrue((boolean)leaseThree.hasExpired());
        Assertions.assertThrowsExactly(LeaseNotFoundException.class, () -> manager.get((Object)resourceThree), (String)("Resource: " + resourceThree));
        manager.shutdown();
    }

    @Test
    public void testCustomLeaseTimeout() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo, 10000L);
        Lease leaseThree = manager.acquire((Object)resourceThree, 50000L);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assertions.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        Assertions.assertFalse((boolean)leaseTwo.hasExpired());
        Assertions.assertFalse((boolean)leaseThree.hasExpired());
        Assertions.assertEquals((long)5000L, (long)leaseOne.getLeaseLifeTime());
        Assertions.assertEquals((long)10000L, (long)leaseTwo.getLeaseLifeTime());
        Assertions.assertEquals((long)50000L, (long)leaseThree.getLeaseLifeTime());
        manager.shutdown();
    }

    @Test
    public void testLeaseCallback() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne, () -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease in use");
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Assertions.assertThrowsExactly(LeaseNotFoundException.class, () -> manager.get((Object)resourceOne), (String)("Resource: " + resourceOne));
        Assertions.assertEquals((Object)"lease expired", leaseStatus.get(resourceOne));
    }

    @Test
    public void testCallbackExecutionInCaseOfLeaseRelease() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne, () -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease in use");
        leaseStatus.put(resourceOne, "lease released");
        manager.release((Object)resourceOne);
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Assertions.assertThrowsExactly(LeaseNotFoundException.class, () -> manager.get((Object)resourceOne), (String)("Resource: " + resourceOne));
        Assertions.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
    }

    @Test
    public void testLeaseCallbackWithMultipleLeases() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        DummyResource resourceFour = new DummyResource("four");
        DummyResource resourceFive = new DummyResource("five");
        Lease leaseOne = manager.acquire((Object)resourceOne, () -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        Lease leaseTwo = manager.acquire((Object)resourceTwo, () -> {
            leaseStatus.put(resourceTwo, "lease expired");
            return null;
        });
        Lease leaseThree = manager.acquire((Object)resourceThree, () -> {
            leaseStatus.put(resourceThree, "lease expired");
            return null;
        });
        Lease leaseFour = manager.acquire((Object)resourceFour, () -> {
            leaseStatus.put(resourceFour, "lease expired");
            return null;
        });
        Lease leaseFive = manager.acquire((Object)resourceFive, () -> {
            leaseStatus.put(resourceFive, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease in use");
        leaseStatus.put(resourceTwo, "lease in use");
        leaseStatus.put(resourceThree, "lease in use");
        leaseStatus.put(resourceFour, "lease in use");
        leaseStatus.put(resourceFive, "lease in use");
        leaseStatus.put(resourceOne, "lease released");
        manager.release((Object)resourceOne);
        leaseStatus.put(resourceTwo, "lease released");
        manager.release((Object)resourceTwo);
        leaseStatus.put(resourceThree, "lease released");
        manager.release((Object)resourceThree);
        long sleepTime = leaseFive.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Assertions.assertTrue((boolean)leaseTwo.hasExpired());
        Assertions.assertTrue((boolean)leaseThree.hasExpired());
        Assertions.assertTrue((boolean)leaseFour.hasExpired());
        Assertions.assertTrue((boolean)leaseFive.hasExpired());
        Assertions.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
        Assertions.assertEquals((Object)"lease released", leaseStatus.get(resourceTwo));
        Assertions.assertEquals((Object)"lease released", leaseStatus.get(resourceThree));
        Assertions.assertEquals((Object)"lease expired", leaseStatus.get(resourceFour));
        Assertions.assertEquals((Object)"lease expired", leaseStatus.get(resourceFive));
        manager.shutdown();
    }

    @Test
    public void testReuseReleasedLease() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        manager.release((Object)resourceOne);
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Lease sameResourceLease = manager.acquire((Object)resourceOne);
        Assertions.assertEquals((Object)sameResourceLease, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release((Object)resourceOne);
        Assertions.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testReuseTimedOutLease() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assertions.assertTrue((boolean)leaseOne.hasExpired());
        Lease sameResourceLease = manager.acquire((Object)resourceOne);
        Assertions.assertEquals((Object)sameResourceLease, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release((Object)resourceOne);
        Assertions.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testRenewLease() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        leaseOne.renew(5000L);
        Thread.sleep(5000L);
        Assertions.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assertions.assertFalse((boolean)leaseOne.hasExpired());
        manager.release((Object)resourceOne);
        manager.shutdown();
    }

    private static final class DummyResource {
        private final String name;

        private DummyResource(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DummyResource) {
                return this.name.equals(((DummyResource)obj).name);
            }
            return false;
        }

        public String toString() {
            return "DummyResource{name='" + this.name + '\'' + '}';
        }
    }
}

