/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.DefaultUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectedUpgradeFinalizationExecutor<T>
extends DefaultUpgradeFinalizationExecutor<T> {
    static final Logger LOG = LoggerFactory.getLogger(InjectedUpgradeFinalizationExecutor.class);
    private Callable<Boolean> injectTestFunction;
    private UpgradeTestInjectionPoints testInjectionPoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(T component, BasicUpgradeFinalizer<T, ?> finalizer) throws IOException {
        try {
            this.injectTestFunctionAtThisPoint(UpgradeTestInjectionPoints.BEFORE_PRE_FINALIZE_UPGRADE);
            finalizer.emitStartingMsg();
            finalizer.preFinalizeUpgrade(component);
            this.injectTestFunctionAtThisPoint(UpgradeTestInjectionPoints.AFTER_PRE_FINALIZE_UPGRADE);
            super.finalizeFeatures(component, finalizer, finalizer.getVersionManager().unfinalizedFeatures());
            this.injectTestFunctionAtThisPoint(UpgradeTestInjectionPoints.AFTER_COMPLETE_FINALIZATION);
            finalizer.postFinalizeUpgrade(component);
            this.injectTestFunctionAtThisPoint(UpgradeTestInjectionPoints.AFTER_POST_FINALIZE_UPGRADE);
            finalizer.emitFinishedMsg();
        }
        catch (Exception e) {
            LOG.warn("Upgrade Finalization failed with following Exception.", (Throwable)e);
            if (finalizer.getVersionManager().needsFinalization()) {
                finalizer.getVersionManager().setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_REQUIRED);
            }
        }
        finally {
            finalizer.markFinalizationDone();
        }
    }

    public void configureTestInjectionFunction(UpgradeTestInjectionPoints pointIndex, Callable<Boolean> injectedTestFunction) {
        this.injectTestFunction = injectedTestFunction;
        this.testInjectionPoint = pointIndex;
    }

    public void injectTestFunctionAtThisPoint(UpgradeTestInjectionPoints pointIndex) throws Exception {
        if (this.testInjectionPoint != null && pointIndex.getValue() == this.testInjectionPoint.getValue() && this.injectTestFunction != null && this.injectTestFunction.call().booleanValue()) {
            throw new UpgradeTestInjectionAbort();
        }
    }

    static class UpgradeTestInjectionAbort
    extends Exception {
        UpgradeTestInjectionAbort() {
        }
    }

    public static enum UpgradeTestInjectionPoints {
        BEFORE_PRE_FINALIZE_UPGRADE(1),
        AFTER_PRE_FINALIZE_UPGRADE(2),
        AFTER_COMPLETE_FINALIZATION(4),
        AFTER_POST_FINALIZE_UPGRADE(5);

        private int val;

        private UpgradeTestInjectionPoints(int value) {
            this.val = value;
        }

        public int getValue() {
            return this.val;
        }
    }
}

