/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionInstanceFactory;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.VersionFactoryKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestLayoutVersionInstanceFactory {
    private MockInterface m1 = new MockClassV1();
    private MockInterface m2 = new MockClassV2();

    @Test
    public void testRegister() {
        LayoutVersionManager lvm = this.getMockLvm(1, 2);
        LayoutVersionInstanceFactory factory = new LayoutVersionInstanceFactory();
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 0), (Object)this.m1));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 1), (Object)this.m1));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 2), (Object)this.m2));
        Assertions.assertEquals((int)1, (int)factory.getInstances().size());
        Assertions.assertEquals((int)2, (int)((List)factory.getInstances().get("key")).size());
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> factory.register(lvm, this.getKey("key", 1), (Object)new MockClassV1()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("existing entry already"));
        Assertions.assertEquals((int)1, (int)factory.getInstances().size());
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> factory.register(lvm, this.getKey("key2", 4), (Object)new MockClassV2()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("version is greater"));
    }

    @Test
    public void testGet() {
        LayoutVersionManager lvm = this.getMockLvm(2, 3);
        LayoutVersionInstanceFactory factory = new LayoutVersionInstanceFactory();
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 0), null));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 1), (Object)this.m1));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 3), (Object)this.m2));
        MockInterface val = (MockInterface)factory.get(lvm, this.getKey("key", 2));
        Assertions.assertTrue((boolean)(val instanceof MockClassV1));
        val = (MockInterface)factory.get(lvm, this.getKey("key", null));
        Assertions.assertTrue((boolean)(val instanceof MockClassV1));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            MockInterface cfr_ignored_0 = (MockInterface)factory.get(lvm, this.getKey("key", 3));
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("version is greater"));
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            MockInterface cfr_ignored_0 = (MockInterface)factory.get(lvm, this.getKey("key1", 1));
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("No suitable instance found"));
    }

    @Test
    public void testMethodBasedVersionFactory() {
        LayoutVersionManager lvm = this.getMockLvm(1, 2);
        LayoutVersionInstanceFactory factory = new LayoutVersionInstanceFactory();
        MockClassWithVersionedAPIs m = new MockClassWithVersionedAPIs();
        factory.register(lvm, this.getKey("method", 1), m::mockMethodV1);
        factory.register(lvm, this.getKey("method", 2), m::mockMethodV2);
        Supplier method = (Supplier)factory.get(lvm, this.getKey("method", 1));
        Assertions.assertEquals((Object)"v1", method.get());
    }

    private VersionFactoryKey getKey(String key, Integer version) {
        VersionFactoryKey.Builder vfKey = new VersionFactoryKey.Builder().key(key);
        if (version != null) {
            vfKey.version(version);
        }
        return vfKey.build();
    }

    @Test
    public void testOnFinalize() {
        LayoutVersionManager lvm = this.getMockLvm(1, 3);
        LayoutVersionInstanceFactory factory = new LayoutVersionInstanceFactory();
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 1), (Object)this.m1));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key", 3), (Object)this.m2));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key2", 1), (Object)this.m1));
        Assertions.assertTrue((boolean)factory.register(lvm, this.getKey("key2", 2), (Object)this.m2));
        MockInterface val = (MockInterface)factory.get(lvm, this.getKey("key", null));
        Assertions.assertTrue((boolean)(val instanceof MockClassV1));
        Assertions.assertEquals((int)2, (int)factory.getInstances().size());
        Assertions.assertEquals((int)2, (int)((List)factory.getInstances().get("key")).size());
        val = (MockInterface)factory.get(lvm, this.getKey("key2", null));
        Assertions.assertTrue((boolean)(val instanceof MockClassV1));
        LayoutFeature toFeature = this.getMockFeatureWithVersion(3);
        factory.finalizeFeature(toFeature);
        lvm = this.getMockLvm(3, 3);
        val = (MockInterface)factory.get(lvm, this.getKey("key", null));
        Assertions.assertTrue((boolean)(val instanceof MockClassV2));
        Assertions.assertEquals((int)2, (int)factory.getInstances().size());
        Assertions.assertEquals((int)1, (int)((List)factory.getInstances().get("key")).size());
        val = (MockInterface)factory.get(lvm, this.getKey("key2", null));
        Assertions.assertTrue((boolean)(val instanceof MockClassV2));
    }

    private LayoutFeature getMockFeatureWithVersion(int layoutVersion) {
        LayoutFeature feature = (LayoutFeature)Mockito.mock(LayoutFeature.class);
        Mockito.when((Object)feature.layoutVersion()).thenReturn((Object)layoutVersion);
        return feature;
    }

    private LayoutVersionManager getMockLvm(int mlv, int slv) {
        LayoutVersionManager lvm = (LayoutVersionManager)Mockito.mock(LayoutVersionManager.class);
        Mockito.when((Object)lvm.getMetadataLayoutVersion()).thenReturn((Object)mlv);
        Mockito.when((Object)lvm.getSoftwareLayoutVersion()).thenReturn((Object)slv);
        return lvm;
    }

    static class MockClassWithVersionedAPIs {
        MockClassWithVersionedAPIs() {
        }

        public String mockMethodV1() {
            return "v1";
        }

        public String mockMethodV2() {
            return "v2";
        }
    }

    static class MockClassV2
    extends MockClassV1 {
        MockClassV2() {
        }
    }

    static class MockClassV1
    implements MockInterface {
        MockClassV1() {
        }

        @Override
        public String mockMethod() {
            return this.getClass().getSimpleName();
        }
    }

    static interface MockInterface {
        public String mockMethod();
    }
}

