/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.common.StorageInfo;
import org.apache.hadoop.ozone.upgrade.InjectedUpgradeFinalizationExecutor;
import org.slf4j.Logger;

public final class UpgradeTestUtils {
    private UpgradeTestUtils() {
    }

    public static File createVersionFile(File parentDir, HddsProtos.NodeType nodeType, int mlv) throws IOException {
        String versionFileName = "VERSION";
        StorageInfo info = new StorageInfo(nodeType, UUID.randomUUID().toString(), System.currentTimeMillis(), mlv);
        File versionFile = new File(parentDir, "VERSION");
        info.writeTo(versionFile);
        return versionFile;
    }

    public static <T> InjectedUpgradeFinalizationExecutor<T> newPausingFinalizationExecutor(InjectedUpgradeFinalizationExecutor.UpgradeTestInjectionPoints haltingPoint, CountDownLatch pauseLatch, CountDownLatch unpauseLatch, Logger log) {
        InjectedUpgradeFinalizationExecutor executor = new InjectedUpgradeFinalizationExecutor();
        executor.configureTestInjectionFunction(haltingPoint, () -> {
            log.info("Halting upgrade finalization at point: {}", (Object)haltingPoint);
            try {
                pauseLatch.countDown();
                unpauseLatch.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException("SCM test finalization interrupted.", ex);
            }
            log.info("Upgrade finalization resumed from point: {}", (Object)haltingPoint);
            return false;
        });
        return executor;
    }

    public static <T> InjectedUpgradeFinalizationExecutor<T> newTerminatingFinalizationExecutor(InjectedUpgradeFinalizationExecutor.UpgradeTestInjectionPoints haltingPoint, CountDownLatch terminateLatch, Logger log) {
        InjectedUpgradeFinalizationExecutor executor = new InjectedUpgradeFinalizationExecutor();
        executor.configureTestInjectionFunction(haltingPoint, () -> {
            log.info("Terminating upgrade finalization at point: {}. This is expected test execution.", (Object)haltingPoint);
            terminateLatch.countDown();
            return true;
        });
        return executor;
    }
}

