/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.ComponentVersion;

public enum ClientVersion implements ComponentVersion
{
    DEFAULT_VERSION(0, "Initial version"),
    VERSION_HANDLES_UNKNOWN_DN_PORTS(1, "Client version that handles the REPLICATION port in DatanodeDetails."),
    ERASURE_CODING_SUPPORT(2, "This client version has support for Erasure Coding."),
    BUCKET_LAYOUT_SUPPORT(3, "This client version has support for Object Store and File System Optimized Bucket Layouts."),
    FUTURE_VERSION(-1, "Used internally when the server side is older and an unknown client version has arrived from the client.");

    public static final ClientVersion CURRENT;
    public static final int CURRENT_VERSION;
    private static final Map<Integer, ClientVersion> BY_PROTO_VALUE;
    private final int version;
    private final String description;

    private ClientVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public int toProtoValue() {
        return this.version;
    }

    public static ClientVersion fromProtoValue(int value) {
        return BY_PROTO_VALUE.getOrDefault(value, FUTURE_VERSION);
    }

    private static ClientVersion latest() {
        ClientVersion[] versions = ClientVersion.values();
        return versions[versions.length - 2];
    }

    static {
        CURRENT = ClientVersion.latest();
        CURRENT_VERSION = ClientVersion.CURRENT.version;
        BY_PROTO_VALUE = Arrays.stream(ClientVersion.values()).collect(Collectors.toMap(ClientVersion::toProtoValue, Function.identity()));
    }
}

