/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;

@InterfaceAudience.Private
public final class CommandHandlerMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = CommandHandlerMetrics.class.getSimpleName();
    private final Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler> handlerMap;
    private final Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, AtomicInteger> commandCount;

    private CommandHandlerMetrics(Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler> handlerMap) {
        this.handlerMap = handlerMap;
        this.commandCount = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, AtomicInteger>();
        handlerMap.forEach((k, v) -> this.commandCount.put((StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type)k, new AtomicInteger()));
    }

    public static CommandHandlerMetrics create(Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler> handlerMap) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CommandHandlerMetrics)ms.register(SOURCE_NAME, "CommandHandlerMetrics Metrics", (Object)new CommandHandlerMetrics(handlerMap));
    }

    public void increaseCommandCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type) {
        this.commandCount.get(type).addAndGet(1);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        for (Map.Entry<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler> entry : this.handlerMap.entrySet()) {
            int maxPoolSize;
            CommandHandler commandHandler = entry.getValue();
            MetricsRecordBuilder builder = collector.addRecord(SOURCE_NAME).setContext("CommandHandlerMetrics").tag((MetricsInfo)CommandMetricsMetricsInfo.Command, commandHandler.getCommandType().name());
            builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.TotalRunTimeMs, commandHandler.getTotalRunTime());
            builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.QueueWaitingTaskCount, commandHandler.getQueuedCount());
            builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.InvocationCount, commandHandler.getInvocationCount());
            int activePoolSize = commandHandler.getThreadPoolActivePoolSize();
            if (activePoolSize >= 0) {
                builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.ThreadPoolActivePoolSize, activePoolSize);
            }
            if ((maxPoolSize = commandHandler.getThreadPoolMaxPoolSize()) >= 0) {
                builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.ThreadPoolMaxPoolSize, maxPoolSize);
            }
            builder.addGauge((MetricsInfo)CommandMetricsMetricsInfo.CommandReceivedCount, this.commandCount.get(commandHandler.getCommandType()).get());
        }
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    static enum CommandMetricsMetricsInfo implements MetricsInfo
    {
        Command("The type of the SCM command"),
        TotalRunTimeMs("The total runtime of the command handler in milliseconds"),
        QueueWaitingTaskCount("The number of queued tasks waiting for execution"),
        InvocationCount("The number of times the command handler has been invoked"),
        ThreadPoolActivePoolSize("The number of active threads in the thread pool"),
        ThreadPoolMaxPoolSize("The maximum number of threads in the thread pool"),
        CommandReceivedCount("The number of received SCM commands for each command type");

        private final String desc;

        private CommandMetricsMetricsInfo(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

