/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.interfaces.StorageLocationReportMXBean;

public final class StorageLocationReport
implements StorageLocationReportMXBean {
    private final String id;
    private final boolean failed;
    private final long capacity;
    private final long scmUsed;
    private final long remaining;
    private final StorageType storageType;
    private final String storageLocation;

    private StorageLocationReport(String id, boolean failed, long capacity, long scmUsed, long remaining, StorageType storageType, String storageLocation) {
        this.id = id;
        this.failed = failed;
        this.capacity = capacity;
        this.scmUsed = scmUsed;
        this.remaining = remaining;
        this.storageType = storageType;
        this.storageLocation = storageLocation;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getScmUsed() {
        return this.scmUsed;
    }

    @Override
    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @Override
    public String getStorageTypeName() {
        return this.storageType.name();
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    private StorageContainerDatanodeProtocolProtos.StorageTypeProto getStorageTypeProto() throws IOException {
        return StorageLocationReport.getStorageTypeProto(this.getStorageType());
    }

    public static StorageContainerDatanodeProtocolProtos.StorageTypeProto getStorageTypeProto(StorageType type) throws IOException {
        StorageContainerDatanodeProtocolProtos.StorageTypeProto storageTypeProto;
        switch (type) {
            case SSD: {
                storageTypeProto = StorageContainerDatanodeProtocolProtos.StorageTypeProto.SSD;
                break;
            }
            case DISK: {
                storageTypeProto = StorageContainerDatanodeProtocolProtos.StorageTypeProto.DISK;
                break;
            }
            case ARCHIVE: {
                storageTypeProto = StorageContainerDatanodeProtocolProtos.StorageTypeProto.ARCHIVE;
                break;
            }
            case PROVIDED: {
                storageTypeProto = StorageContainerDatanodeProtocolProtos.StorageTypeProto.PROVIDED;
                break;
            }
            case RAM_DISK: {
                storageTypeProto = StorageContainerDatanodeProtocolProtos.StorageTypeProto.RAM_DISK;
                break;
            }
            default: {
                throw new IOException("Illegal Storage Type specified");
            }
        }
        return storageTypeProto;
    }

    private static StorageType getStorageType(StorageContainerDatanodeProtocolProtos.StorageTypeProto proto) throws IOException {
        StorageType storageType;
        switch (proto) {
            case SSD: {
                storageType = StorageType.SSD;
                break;
            }
            case DISK: {
                storageType = StorageType.DISK;
                break;
            }
            case ARCHIVE: {
                storageType = StorageType.ARCHIVE;
                break;
            }
            case PROVIDED: {
                storageType = StorageType.PROVIDED;
                break;
            }
            case RAM_DISK: {
                storageType = StorageType.RAM_DISK;
                break;
            }
            default: {
                throw new IOException("Illegal Storage Type specified");
            }
        }
        return storageType;
    }

    public StorageContainerDatanodeProtocolProtos.StorageReportProto getProtoBufMessage() throws IOException {
        StorageContainerDatanodeProtocolProtos.StorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder();
        return srb.setStorageUuid(this.getId()).setCapacity(this.getCapacity()).setScmUsed(this.getScmUsed()).setRemaining(this.getRemaining()).setStorageType(this.getStorageTypeProto()).setStorageLocation(this.getStorageLocation()).setFailed(this.isFailed()).build();
    }

    public StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto getMetadataProtoBufMessage() throws IOException {
        StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.newBuilder();
        return srb.setCapacity(this.getCapacity()).setScmUsed(this.getScmUsed()).setRemaining(this.getRemaining()).setStorageType(this.getStorageTypeProto()).setStorageLocation(this.getStorageLocation()).setFailed(this.isFailed()).build();
    }

    public static StorageLocationReport getFromProtobuf(StorageContainerDatanodeProtocolProtos.StorageReportProto report) throws IOException {
        Builder builder = StorageLocationReport.newBuilder();
        builder.setId(report.getStorageUuid()).setStorageLocation(report.getStorageLocation());
        if (report.hasCapacity()) {
            builder.setCapacity(report.getCapacity());
        }
        if (report.hasScmUsed()) {
            builder.setScmUsed(report.getScmUsed());
        }
        if (report.hasStorageType()) {
            builder.setStorageType(StorageLocationReport.getStorageType(report.getStorageType()));
        }
        if (report.hasRemaining()) {
            builder.setRemaining(report.getRemaining());
        }
        if (report.hasFailed()) {
            builder.setFailed(report.getFailed());
        }
        return builder.build();
    }

    public static StorageLocationReport getMetadataFromProtobuf(StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto report) throws IOException {
        Builder builder = StorageLocationReport.newBuilder();
        builder.setStorageLocation(report.getStorageLocation());
        if (report.hasCapacity()) {
            builder.setCapacity(report.getCapacity());
        }
        if (report.hasScmUsed()) {
            builder.setScmUsed(report.getScmUsed());
        }
        if (report.hasStorageType()) {
            builder.setStorageType(StorageLocationReport.getStorageType(report.getStorageType()));
        }
        if (report.hasRemaining()) {
            builder.setRemaining(report.getRemaining());
        }
        if (report.hasFailed()) {
            builder.setFailed(report.getFailed());
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private boolean failed;
        private long capacity;
        private long scmUsed;
        private long remaining;
        private StorageType storageType;
        private String storageLocation;

        public Builder setId(String idValue) {
            this.id = idValue;
            return this;
        }

        public Builder setFailed(boolean failedValue) {
            this.failed = failedValue;
            return this;
        }

        public Builder setCapacity(long capacityValue) {
            this.capacity = capacityValue;
            return this;
        }

        public Builder setScmUsed(long scmUsedValue) {
            this.scmUsed = scmUsedValue;
            return this;
        }

        public Builder setRemaining(long remainingValue) {
            this.remaining = remainingValue;
            return this;
        }

        public Builder setStorageType(StorageType storageTypeValue) {
            this.storageType = storageTypeValue;
            return this;
        }

        public Builder setStorageLocation(String storageLocationValue) {
            this.storageLocation = storageLocationValue;
            return this;
        }

        public StorageLocationReport build() {
            return new StorageLocationReport(this.id, this.failed, this.capacity, this.scmUsed, this.remaining, this.storageType, this.storageLocation);
        }
    }
}

