/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicateContainerCommandHandler
implements CommandHandler {
    static final Logger LOG = LoggerFactory.getLogger(ReplicateContainerCommandHandler.class);
    private int invocationCount;
    private long totalTime;
    private ConfigurationSource conf;
    private ReplicationSupervisor supervisor;
    private ContainerReplicator downloadReplicator;
    private ContainerReplicator pushReplicator;

    public ReplicateContainerCommandHandler(ConfigurationSource conf, ReplicationSupervisor supervisor, ContainerReplicator downloadReplicator, ContainerReplicator pushReplicator) {
        this.conf = conf;
        this.supervisor = supervisor;
        this.downloadReplicator = downloadReplicator;
        this.pushReplicator = pushReplicator;
    }

    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        ReplicateContainerCommand replicateCommand = (ReplicateContainerCommand)command;
        List<DatanodeDetails> sourceDatanodes = replicateCommand.getSourceDatanodes();
        long containerID = replicateCommand.getContainerID();
        DatanodeDetails target = replicateCommand.getTargetDatanode();
        Preconditions.checkArgument((!sourceDatanodes.isEmpty() || target != null ? 1 : 0) != 0, (String)"Replication command is received for container %s without source or target datanodes.", (long)containerID);
        ContainerReplicator replicator = replicateCommand.getTargetDatanode() == null ? this.downloadReplicator : this.pushReplicator;
        ReplicationTask task = new ReplicationTask(replicateCommand, replicator);
        this.supervisor.addTask(task);
    }

    @Override
    public int getQueuedCount() {
        return this.supervisor.getInFlightReplications(ReplicationTask.class);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount > 0) {
            return this.totalTime / (long)this.invocationCount;
        }
        return 0L;
    }

    @Override
    public long getTotalRunTime() {
        return this.totalTime;
    }
}

