/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.container.common.utils.ContainerCacheMetrics;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerCache
extends LRUMap {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCache.class);
    private final Lock lock = new ReentrantLock();
    private static ContainerCache cache;
    private static final float LOAD_FACTOR = 0.75f;
    private final Striped<Lock> rocksDBLock;
    private static ContainerCacheMetrics metrics;

    private ContainerCache(int maxSize, int stripes, float loadFactor, boolean scanUntilRemovable) {
        super(maxSize, loadFactor, scanUntilRemovable);
        this.rocksDBLock = Striped.lazyWeakLock((int)stripes);
    }

    @VisibleForTesting
    public ContainerCacheMetrics getMetrics() {
        return metrics;
    }

    public static synchronized ContainerCache getInstance(ConfigurationSource conf) {
        if (cache == null) {
            int cacheSize = conf.getInt("ozone.container.cache.size", 1024);
            int stripes = conf.getInt("ozone.container.cache.lock.stripes", 1024);
            cache = new ContainerCache(cacheSize, stripes, 0.75f, true);
            metrics = ContainerCacheMetrics.create();
        }
        return cache;
    }

    public void shutdownCache() {
        this.lock.lock();
        try {
            MapIterator iterator = cache.mapIterator();
            while (iterator.hasNext()) {
                iterator.next();
                ReferenceCountedDB db = (ReferenceCountedDB)iterator.getValue();
                Preconditions.checkArgument((boolean)this.cleanupDb(db), (String)"refCount:", (long)db.getReferenceCount());
            }
            cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
        ReferenceCountedDB db = (ReferenceCountedDB)entry.getValue();
        this.lock.lock();
        try {
            metrics.incNumCacheEvictions();
            boolean bl = this.cleanupDb(db);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceCountedDB getDB(long containerID, String containerDBType, String containerDBPath, String schemaVersion, ConfigurationSource conf) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Lock containerLock = (Lock)this.rocksDBLock.get((Object)containerDBPath);
        containerLock.lock();
        metrics.incNumDbGetOps();
        try {
            ReferenceCountedDB currentDB;
            ReferenceCountedDB db;
            block19: {
                this.lock.lock();
                try {
                    db = (ReferenceCountedDB)this.get(containerDBPath);
                    if (db != null && !db.isClosed()) {
                        metrics.incNumCacheHits();
                        db.incrementReference();
                        ReferenceCountedDB referenceCountedDB = db;
                        return referenceCountedDB;
                    }
                    if (db != null && db.isClosed()) {
                        this.removeDB(containerDBPath);
                    }
                    metrics.incNumCacheMisses();
                }
                finally {
                    this.lock.unlock();
                }
                try {
                    long start = Time.monotonicNow();
                    DatanodeStore store = BlockUtils.getUncachedDatanodeStore(containerDBPath, schemaVersion, conf, false);
                    db = new ReferenceCountedDB(store, containerDBPath);
                    metrics.incDbOpenLatency(Time.monotonicNow() - start);
                }
                catch (Exception e) {
                    LOG.error("Error opening DB. Container:{} ContainerPath:{}", new Object[]{containerID, containerDBPath, e});
                    throw e;
                }
                this.lock.lock();
                try {
                    currentDB = (ReferenceCountedDB)this.get(containerDBPath);
                    if (currentDB == null || currentDB.isClosed()) break block19;
                    currentDB.incrementReference();
                    this.cleanupDb(db);
                    ReferenceCountedDB referenceCountedDB = currentDB;
                    this.lock.unlock();
                    return referenceCountedDB;
                }
                catch (Throwable throwable) {
                    this.lock.unlock();
                    throw throwable;
                }
            }
            if (currentDB != null && currentDB.isClosed()) {
                this.removeDB(containerDBPath);
            }
            this.put(containerDBPath, db);
            db.incrementReference();
            ReferenceCountedDB referenceCountedDB = db;
            this.lock.unlock();
            return referenceCountedDB;
        }
        finally {
            containerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDB(String containerDBPath) {
        this.lock.lock();
        try {
            ReferenceCountedDB db = (ReferenceCountedDB)this.get(containerDBPath);
            if (db != null) {
                boolean cleaned = this.cleanupDb(db);
                if (!db.isClosed()) {
                    Preconditions.checkArgument((boolean)cleaned, (String)"refCount:", (long)db.getReferenceCount());
                }
            }
            this.remove(containerDBPath);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean cleanupDb(ReferenceCountedDB db) {
        long time = Time.monotonicNow();
        boolean ret = db.cleanup();
        if (ret) {
            metrics.incDbCloseLatency(Time.monotonicNow() - time);
        }
        return ret;
    }

    public void addDB(String containerDBPath, ReferenceCountedDB db) {
        this.lock.lock();
        try {
            this.putIfAbsent(containerDBPath, db);
        }
        finally {
            this.lock.unlock();
        }
    }
}

