/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;

public class TarContainerPacker
implements ContainerPacker<KeyValueContainerData> {
    static final String CHUNKS_DIR_NAME = "chunks";
    static final String DB_DIR_NAME = "db";
    static final String CONTAINER_FILE_NAME = "container.yaml";
    private final CopyContainerCompression compression;

    public TarContainerPacker(CopyContainerCompression compression) {
        this.compression = compression;
    }

    @Override
    public byte[] unpackContainerData(Container<KeyValueContainerData> container, InputStream input, Path tmpDir, Path destContainerDir) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        long containerId = containerData.getContainerID();
        Path containerUntarDir = tmpDir.resolve(String.valueOf(containerId));
        if (containerUntarDir.toFile().exists()) {
            FileUtils.deleteDirectory((File)containerUntarDir.toFile());
        }
        Path dbRoot = TarContainerPacker.getDbPath(containerUntarDir, containerData);
        Path chunksRoot = TarContainerPacker.getChunkPath(containerUntarDir, containerData);
        byte[] descriptorFileContent = this.innerUnpack(input, dbRoot, chunksRoot);
        if (!Files.exists(destContainerDir, new LinkOption[0])) {
            Files.createDirectories(destContainerDir, new FileAttribute[0]);
        }
        if (!FileUtils.isEmptyDirectory((File)destContainerDir.toFile())) {
            String errorMessage = "Container " + containerId + " unpack failed because ContainerFile " + destContainerDir.toAbsolutePath() + " already exists";
            throw new StorageContainerException(errorMessage, ContainerProtos.Result.CONTAINER_ALREADY_EXISTS);
        }
        Files.move(containerUntarDir, destContainerDir, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        return descriptorFileContent;
    }

    private void extractEntry(ArchiveEntry entry, InputStream input, long size, Path ancestor, Path path) throws IOException {
        HddsUtils.validatePath((Path)path, (Path)ancestor);
        if (entry.isDirectory()) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (FileOutputStream fileOutput = new FileOutputStream(path.toFile());
                 BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize + 1];
                long remaining = size;
                while (remaining > 0L) {
                    int len = (int)Math.min(remaining, (long)bufferSize);
                    int read = input.read(buffer, 0, len);
                    if (read >= 0) {
                        remaining -= (long)read;
                        ((OutputStream)output).write(buffer, 0, read);
                        continue;
                    }
                    remaining = 0L;
                }
            }
        }
    }

    @Override
    public void pack(Container<KeyValueContainerData> container, OutputStream output) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        try (ArchiveOutputStream archiveOutput = TarContainerPacker.tar(this.compress(output));){
            TarContainerPacker.includeFile(container.getContainerFile(), CONTAINER_FILE_NAME, archiveOutput);
            this.includePath(TarContainerPacker.getDbPath(containerData), DB_DIR_NAME, archiveOutput);
            this.includePath(Paths.get(containerData.getChunksPath(), new String[0]), CHUNKS_DIR_NAME, archiveOutput);
        }
    }

    @Override
    public byte[] unpackContainerDescriptor(InputStream input) throws IOException {
        try (ArchiveInputStream archiveInput = TarContainerPacker.untar(this.decompress(input));){
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (CONTAINER_FILE_NAME.equals(name)) {
                    byte[] byArray = this.readEntry((InputStream)archiveInput, entry.getSize());
                    return byArray;
                }
                entry = archiveInput.getNextEntry();
            }
        }
        throw new IOException("Container descriptor is missing from the container archive.");
    }

    public static Path getDbPath(KeyValueContainerData containerData) {
        if (containerData.hasSchema("3")) {
            return DatanodeStoreSchemaThreeImpl.getDumpDir(new File(containerData.getMetadataPath())).toPath();
        }
        return containerData.getDbFile().toPath();
    }

    public static Path getDbPath(Path baseDir, KeyValueContainerData containerData) {
        if (baseDir.toAbsolutePath().toString().equals(containerData.getContainerPath())) {
            return TarContainerPacker.getDbPath(containerData);
        }
        Path containerPath = Paths.get(containerData.getContainerPath(), new String[0]);
        Path dbPath = Paths.get(containerData.getDbFile().getPath(), new String[0]);
        Path relativePath = containerPath.relativize(dbPath);
        if (containerData.hasSchema("3")) {
            Path metadataDir = KeyValueContainerLocationUtil.getContainerMetaDataPath(baseDir.toString()).toPath();
            return DatanodeStoreSchemaThreeImpl.getDumpDir(metadataDir.toFile()).toPath();
        }
        return baseDir.resolve(relativePath);
    }

    public static Path getChunkPath(Path baseDir, KeyValueContainerData containerData) {
        Path chunkDir = KeyValueContainerLocationUtil.getChunksLocationPath(baseDir.toString()).toPath();
        return chunkDir;
    }

    private byte[] readEntry(InputStream input, long size) throws IOException {
        int read;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize + 1];
        for (long remaining = size; remaining > 0L; remaining -= (long)read) {
            int len = (int)Math.min(remaining, (long)bufferSize);
            read = input.read(buffer, 0, len);
            output.write(buffer, 0, read);
        }
        return output.toByteArray();
    }

    private void includePath(Path dir, String subdir, ArchiveOutputStream archiveOutput) throws IOException {
        ArchiveEntry entry = archiveOutput.createArchiveEntry(dir.toFile(), subdir);
        archiveOutput.putArchiveEntry(entry);
        archiveOutput.closeArchiveEntry();
        try (Stream<Path> dirEntries = Files.list(dir);){
            for (Path path : dirEntries.collect(Collectors.toList())) {
                String entryName = subdir + "/" + path.getFileName();
                TarContainerPacker.includeFile(path.toFile(), entryName, archiveOutput);
            }
        }
    }

    static void includeFile(File file, String entryName, ArchiveOutputStream archiveOutput) throws IOException {
        ArchiveEntry entry = archiveOutput.createArchiveEntry(file, entryName);
        archiveOutput.putArchiveEntry(entry);
        try (FileInputStream input = new FileInputStream(file);){
            IOUtils.copy((InputStream)input, (OutputStream)archiveOutput);
        }
        archiveOutput.closeArchiveEntry();
    }

    private static ArchiveInputStream untar(InputStream input) {
        return new TarArchiveInputStream(input);
    }

    private static ArchiveOutputStream tar(OutputStream output) {
        TarArchiveOutputStream os = new TarArchiveOutputStream(output);
        os.setBigNumberMode(2);
        return os;
    }

    @VisibleForTesting
    InputStream decompress(InputStream input) throws IOException {
        return this.compression.wrap(input);
    }

    @VisibleForTesting
    OutputStream compress(OutputStream output) throws IOException {
        return this.compression.wrap(output);
    }

    private byte[] innerUnpack(InputStream input, Path dbRoot, Path chunksRoot) throws IOException {
        byte[] descriptorFileContent = null;
        try (ArchiveInputStream archiveInput = TarContainerPacker.untar(this.decompress(input));){
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (entry != null) {
                Path destinationPath;
                String name = entry.getName();
                long size = entry.getSize();
                if (name.startsWith("db/")) {
                    destinationPath = dbRoot.resolve(name.substring(DB_DIR_NAME.length() + 1));
                    this.extractEntry(entry, (InputStream)archiveInput, size, dbRoot, destinationPath);
                } else if (name.startsWith("chunks/")) {
                    destinationPath = chunksRoot.resolve(name.substring(CHUNKS_DIR_NAME.length() + 1));
                    this.extractEntry(entry, (InputStream)archiveInput, size, chunksRoot, destinationPath);
                } else if (CONTAINER_FILE_NAME.equals(name)) {
                    descriptorFileContent = this.readEntry((InputStream)archiveInput, size);
                } else {
                    throw new IllegalArgumentException("Unknown entry in the tar file: " + name);
                }
                entry = archiveInput.getNextEntry();
            }
            byte[] byArray = descriptorFileContent;
            return byArray;
        }
    }
}

