/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements BlockManager {
    static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private ConfigurationSource config;
    private static final String DB_NULL_ERR_MSG = "DB cannot be null here";
    private static final String NO_SUCH_BLOCK_ERR_MSG = "Unable to find the block.";
    private final int defaultReadBufferCapacity;
    private final int readMappedBufferThreshold;

    public BlockManagerImpl(ConfigurationSource conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Config cannot be null");
        this.config = conf;
        this.defaultReadBufferCapacity = this.config.getBufferSize("ozone.chunk.read.buffer.default.size", "1MB");
        this.readMappedBufferThreshold = this.config.getBufferSize("ozone.chunk.read.mapped.buffer.threshold", "32KB");
    }

    @Override
    public long putBlock(Container container, BlockData data) throws IOException {
        return this.putBlock(container, data, true);
    }

    @Override
    public long putBlock(Container container, BlockData data, boolean endOfBlock) throws IOException {
        return BlockManagerImpl.persistPutBlock((KeyValueContainer)container, data, this.config, endOfBlock);
    }

    public static long persistPutBlock(KeyValueContainer container, BlockData data, ConfigurationSource config, boolean endOfBlock) throws IOException {
        Preconditions.checkNotNull((Object)data, (Object)"BlockData cannot be null for put operation.");
        Preconditions.checkState((data.getContainerID() >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative");
        KeyValueContainerData containerData = container.getContainerData();
        try (DBHandle db = BlockUtils.getDB(containerData, config);){
            Preconditions.checkNotNull((Object)db, (Object)DB_NULL_ERR_MSG);
            long bcsId = data.getBlockCommitSequenceId();
            long containerBCSId = containerData.getBlockCommitSequenceId();
            if (bcsId != 0L && bcsId <= containerBCSId) {
                LOG.debug("blockCommitSequenceId {} in the Container Db is greater than the supplied value {}. Ignoring it", (Object)containerBCSId, (Object)bcsId);
                long l = data.getSize();
                return l;
            }
            long localID = data.getLocalID();
            boolean isBlockInCache = container.isBlockInPendingPutBlockCache(localID);
            boolean incrBlockCount = false;
            try (BatchOperation batch = db.getStore().getBatchHandler().initBatchOperation();){
                if (!isBlockInCache && db.getStore().getBlockDataTable().get((Object)containerData.getBlockKey(localID)) == null) {
                    incrBlockCount = true;
                }
                db.getStore().getBlockDataTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)data);
                if (bcsId != 0L) {
                    db.getStore().getMetadataTable().putWithBatch(batch, (Object)containerData.getBcsIdKey(), (Object)bcsId);
                }
                db.getStore().getMetadataTable().putWithBatch(batch, (Object)containerData.getBytesUsedKey(), (Object)containerData.getBytesUsed());
                if (incrBlockCount) {
                    db.getStore().getMetadataTable().putWithBatch(batch, (Object)containerData.getBlockCountKey(), (Object)(containerData.getBlockCount() + 1L));
                }
                db.getStore().getBatchHandler().commitBatchOperation(batch);
            }
            if (bcsId != 0L) {
                container.updateBlockCommitSequenceId(bcsId);
            }
            if (incrBlockCount) {
                containerData.incrBlockCount();
            }
            if (!isBlockInCache && !endOfBlock) {
                container.addToPendingPutBlockCache(localID);
            } else if (isBlockInCache && endOfBlock) {
                container.removeFromPendingPutBlockCache(localID);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Block " + data.getBlockID() + " successfully committed with bcsId " + bcsId + " chunk size " + data.getChunks().size());
            }
            long l = data.getSize();
            return l;
        }
    }

    @Override
    public BlockData getBlock(Container container, BlockID blockID) throws IOException {
        long bcsId = blockID.getBlockCommitSequenceId();
        Preconditions.checkNotNull((Object)blockID, (Object)"BlockID cannot be null in GetBlock request");
        Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null");
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        long containerBCSId = containerData.getBlockCommitSequenceId();
        if (containerBCSId < bcsId) {
            throw new StorageContainerException("Unable to find the block with bcsID " + bcsId + " .Container " + containerData.getContainerID() + " bcsId is " + containerBCSId + ".", ContainerProtos.Result.UNKNOWN_BCSID);
        }
        try (DBHandle db = BlockUtils.getDB(containerData, this.config);){
            Preconditions.checkNotNull((Object)db, (Object)DB_NULL_ERR_MSG);
            BlockData blockData = this.getBlockByID(db, blockID, containerData);
            long id = blockData.getBlockID().getBlockCommitSequenceId();
            if (id < bcsId) {
                throw new StorageContainerException("bcsId " + bcsId + " mismatches with existing block Id " + id + " for block " + blockID + ".", ContainerProtos.Result.BCSID_MISMATCH);
            }
            BlockData blockData2 = blockData;
            return blockData2;
        }
    }

    @Override
    public long getCommittedBlockLength(Container container, BlockID blockID) throws IOException {
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        try (DBHandle db = BlockUtils.getDB(containerData, this.config);){
            Preconditions.checkNotNull((Object)db, (Object)DB_NULL_ERR_MSG);
            BlockData blockData = this.getBlockByID(db, blockID, containerData);
            long l = blockData.getSize();
            return l;
        }
    }

    @Override
    public int getDefaultReadBufferCapacity() {
        return this.defaultReadBufferCapacity;
    }

    @Override
    public int getReadMappedBufferThreshold() {
        return this.readMappedBufferThreshold;
    }

    @Override
    public void deleteBlock(Container container, BlockID blockID) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * Loose catch block
     */
    @Override
    public List<BlockData> listBlock(Container container, long startLocalID, int count) throws IOException {
        Preconditions.checkNotNull((Object)container, (Object)"container cannot be null");
        Preconditions.checkState((startLocalID >= 0L || startLocalID == -1L ? 1 : 0) != 0, (Object)"startLocal ID cannot be negative");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be a positive number.");
        container.readLock();
        try {
            ArrayList<Object> result = null;
            KeyValueContainerData cData = (KeyValueContainerData)container.getContainerData();
            try (DBHandle db = BlockUtils.getDB(cData, this.config);){
                result = new ArrayList<Object>();
                String startKey = startLocalID == -1L ? cData.startKeyEmpty() : cData.getBlockKey(startLocalID);
                List range = db.getStore().getBlockDataTable().getSequentialRangeKVs((Object)startKey, count, (Object)cData.containerPrefix(), new MetadataKeyFilters.MetadataKeyFilter[]{cData.getUnprefixedKeyFilter()});
                for (Table.KeyValue entry : range) {
                    result.add(entry.getValue());
                }
                ArrayList<Object> arrayList = result;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            container.readUnlock();
        }
    }

    @Override
    public void shutdown() {
        BlockUtils.shutdownCache(this.config);
    }

    private BlockData getBlockByID(DBHandle db, BlockID blockID, KeyValueContainerData containerData) throws IOException {
        String blockKey = containerData.getBlockKey(blockID.getLocalID());
        BlockData blockData = (BlockData)db.getStore().getBlockDataTable().get((Object)blockKey);
        if (blockData == null) {
            throw new StorageContainerException("Unable to find the block. BlockID : " + blockID, ContainerProtos.Result.NO_SUCH_BLOCK);
        }
        return blockData;
    }
}

