/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.ConfigurationTarget;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CopyContainerCompression {
    NO_COMPRESSION("no_compression"){

        @Override
        public InputStream wrap(InputStream input) {
            return input;
        }

        @Override
        public OutputStream wrap(OutputStream output) {
            return output;
        }
    }
    ,
    GZIP("gz"),
    LZ4("lz4-framed"),
    SNAPPY("snappy-framed"),
    ZSTD("zstd");

    private final String compressorFactoryName;
    private static final Logger LOG;
    private static final CopyContainerCompression DEFAULT_COMPRESSION;

    private CopyContainerCompression(String compressorFactoryName) {
        this.compressorFactoryName = compressorFactoryName;
    }

    public static CopyContainerCompression getConf(ConfigurationSource conf) {
        try {
            return (CopyContainerCompression)conf.getEnum("hdds.container.replication.compression", (Enum)DEFAULT_COMPRESSION);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unsupported compression codec {}, defaulting to {}", (Object)conf.get("hdds.container.replication.compression"), (Object)DEFAULT_COMPRESSION);
            return DEFAULT_COMPRESSION;
        }
    }

    public void setOn(ConfigurationTarget conf) {
        conf.setEnum("hdds.container.replication.compression", (Enum)this);
    }

    public static CopyContainerCompression getDefaultCompression() {
        return NO_COMPRESSION;
    }

    public ContainerProtos.CopyContainerCompressProto toProto() {
        return ContainerProtos.CopyContainerCompressProto.valueOf((String)this.name());
    }

    public static CopyContainerCompression fromProto(ContainerProtos.CopyContainerCompressProto proto) {
        if (proto == null) {
            return CopyContainerCompression.getDefaultCompression();
        }
        try {
            return CopyContainerCompression.valueOf(proto.name());
        }
        catch (IllegalArgumentException e) {
            return CopyContainerCompression.getDefaultCompression();
        }
    }

    public InputStream wrap(InputStream input) throws IOException {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(this.compressorFactoryName, input);
        }
        catch (CompressorException e) {
            throw CopyContainerCompression.toIOException(e);
        }
    }

    public OutputStream wrap(OutputStream output) throws IOException {
        try {
            return new CompressorStreamFactory().createCompressorOutputStream(this.compressorFactoryName, output);
        }
        catch (CompressorException e) {
            throw CopyContainerCompression.toIOException(e);
        }
    }

    private static IOException toIOException(CompressorException e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        return new IOException(e);
    }

    static {
        LOG = LoggerFactory.getLogger(CopyContainerCompression.class);
        DEFAULT_COMPRESSION = NO_COMPRESSION;
    }
}

