/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsIdFactory;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReconstructECContainersCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.ReconstructECContainersCommandProto> {
    private final long containerID;
    private final List<DatanodeDetailsAndReplicaIndex> sources;
    private final List<DatanodeDetails> targetDatanodes;
    private final byte[] missingContainerIndexes;
    private final ECReplicationConfig ecReplicationConfig;

    public ReconstructECContainersCommand(long containerID, List<DatanodeDetailsAndReplicaIndex> sources, List<DatanodeDetails> targetDatanodes, byte[] missingContainerIndexes, ECReplicationConfig ecReplicationConfig) {
        this(containerID, sources, targetDatanodes, missingContainerIndexes, ecReplicationConfig, HddsIdFactory.getLongId());
    }

    public ReconstructECContainersCommand(long containerID, List<DatanodeDetailsAndReplicaIndex> sourceDatanodes, List<DatanodeDetails> targetDatanodes, byte[] missingContainerIndexes, ECReplicationConfig ecReplicationConfig, long id) {
        super(id);
        this.containerID = containerID;
        this.sources = sourceDatanodes;
        this.targetDatanodes = targetDatanodes;
        this.missingContainerIndexes = Arrays.copyOf(missingContainerIndexes, missingContainerIndexes.length);
        this.ecReplicationConfig = ecReplicationConfig;
        if (targetDatanodes.size() != missingContainerIndexes.length) {
            throw new IllegalArgumentException("Number of target datanodes and container indexes should be same");
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconstructECContainersCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.ReconstructECContainersCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.ReconstructECContainersCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.ReconstructECContainersCommandProto.newBuilder().setCmdId(this.getId()).setContainerID(this.containerID);
        for (DatanodeDetailsAndReplicaIndex datanodeDetailsAndReplicaIndex : this.sources) {
            builder.addSources(datanodeDetailsAndReplicaIndex.toProto());
        }
        for (DatanodeDetails datanodeDetails : this.targetDatanodes) {
            builder.addTargets(datanodeDetails.getProtoBufMessage());
        }
        builder.setMissingContainerIndexes(ReconstructECContainersCommand.getByteString(this.missingContainerIndexes));
        builder.setEcReplicationConfig(this.ecReplicationConfig.toProto());
        return builder.build();
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static ReconstructECContainersCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.ReconstructECContainersCommandProto protoMessage) {
        Preconditions.checkNotNull((Object)protoMessage);
        List<DatanodeDetailsAndReplicaIndex> srcDatanodeDetails = protoMessage.getSourcesList().stream().map(a -> DatanodeDetailsAndReplicaIndex.fromProto(a)).collect(Collectors.toList());
        List<DatanodeDetails> targetDatanodeDetails = protoMessage.getTargetsList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList());
        return new ReconstructECContainersCommand(protoMessage.getContainerID(), srcDatanodeDetails, targetDatanodeDetails, protoMessage.getMissingContainerIndexes().toByteArray(), new ECReplicationConfig(protoMessage.getEcReplicationConfig()), protoMessage.getCmdId());
    }

    public long getContainerID() {
        return this.containerID;
    }

    public List<DatanodeDetailsAndReplicaIndex> getSources() {
        return this.sources;
    }

    public List<DatanodeDetails> getTargetDatanodes() {
        return this.targetDatanodes;
    }

    public byte[] getMissingContainerIndexes() {
        return Arrays.copyOf(this.missingContainerIndexes, this.missingContainerIndexes.length);
    }

    public ECReplicationConfig getEcReplicationConfig() {
        return this.ecReplicationConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType()).append(": containerID: ").append(this.containerID).append(", replicationConfig: ").append(this.ecReplicationConfig).append(", sources: [").append(this.getSources().stream().map(a -> ((DatanodeDetailsAndReplicaIndex)a).dnDetails + " replicaIndex: " + a.getReplicaIndex()).collect(Collectors.joining(", "))).append("]").append(", targets: ").append(this.getTargetDatanodes()).append(", missingIndexes: ").append(Arrays.toString(this.missingContainerIndexes));
        return sb.toString();
    }

    public static class DatanodeDetailsAndReplicaIndex {
        private DatanodeDetails dnDetails;
        private int replicaIndex;

        public DatanodeDetailsAndReplicaIndex(DatanodeDetails dnDetails, int replicaIndex) {
            this.dnDetails = dnDetails;
            this.replicaIndex = replicaIndex;
        }

        public DatanodeDetails getDnDetails() {
            return this.dnDetails;
        }

        public int getReplicaIndex() {
            return this.replicaIndex;
        }

        public StorageContainerDatanodeProtocolProtos.DatanodeDetailsAndReplicaIndexProto toProto() {
            return StorageContainerDatanodeProtocolProtos.DatanodeDetailsAndReplicaIndexProto.newBuilder().setDatanodeDetails(this.dnDetails.getProtoBufMessage()).setReplicaIndex(this.replicaIndex).build();
        }

        public static DatanodeDetailsAndReplicaIndex fromProto(StorageContainerDatanodeProtocolProtos.DatanodeDetailsAndReplicaIndexProto proto) {
            return new DatanodeDetailsAndReplicaIndex(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)proto.getDatanodeDetails()), proto.getReplicaIndex());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatanodeDetailsAndReplicaIndex that = (DatanodeDetailsAndReplicaIndex)o;
            return this.replicaIndex == that.replicaIndex && Objects.equals(this.dnDetails, that.dnDetails);
        }

        public int hashCode() {
            return Objects.hash(this.dnDetails, this.replicaIndex);
        }
    }
}

