/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.managed.ManagedBlockBasedTableConfig;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksObject;
import org.rocksdb.TableFormatConfig;

public class ManagedColumnFamilyOptions
extends ColumnFamilyOptions {
    @Nullable
    private final StackTraceElement[] elements = ManagedRocksObjectUtils.getStackTrace();
    private boolean reused = false;

    public ManagedColumnFamilyOptions() {
    }

    public ManagedColumnFamilyOptions(ColumnFamilyOptions columnFamilyOptions) {
        super(columnFamilyOptions);
    }

    public synchronized ManagedColumnFamilyOptions setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        TableFormatConfig previous = this.tableFormatConfig();
        if (previous instanceof ManagedBlockBasedTableConfig) {
            if (!((ManagedBlockBasedTableConfig)previous).isClosed()) {
                throw new IllegalStateException("Overriding an unclosed value.");
            }
        } else if (previous != null) {
            throw new UnsupportedOperationException("Overwrite is not supported for " + previous.getClass());
        }
        super.setTableFormatConfig(tableFormatConfig);
        return this;
    }

    public synchronized ManagedColumnFamilyOptions closeAndSetTableFormatConfig(TableFormatConfig tableFormatConfig) {
        TableFormatConfig previous = this.tableFormatConfig();
        if (previous instanceof ManagedBlockBasedTableConfig) {
            ((ManagedBlockBasedTableConfig)previous).close();
        }
        this.setTableFormatConfig(tableFormatConfig);
        return this;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }

    public boolean isReused() {
        return this.reused;
    }

    protected void finalize() throws Throwable {
        ManagedRocksObjectUtils.assertClosed((RocksObject)this, ManagedRocksObjectUtils.formatStackTrace(this.elements));
        super.finalize();
    }

    public static void closeDeeply(ColumnFamilyOptions options) {
        TableFormatConfig tableFormatConfig = options.tableFormatConfig();
        if (tableFormatConfig instanceof ManagedBlockBasedTableConfig) {
            ((ManagedBlockBasedTableConfig)tableFormatConfig).close();
        }
        options.close();
    }
}

